/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.transformer.builder.MockConverterBuilder;
import org.mule.runtime.core.internal.transformer.graph.ConverterFilter;
import org.mule.runtime.core.internal.transformer.graph.TypeMatchingVertexesFilter;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.Peach;
import org.mule.tck.testmodels.fruit.Seed;

@SmallTest
public class TypeMatchingVertexesFilterTestCase {
    private static final DataType ORANGE_DATA_TYPE = DataType.fromType(Orange.class);
    private static final DataType PEACH_DATA_TYPE = DataType.fromType(Peach.class);
    private static final DataType SEED_DATA_TYPE = DataType.fromType(Seed.class);
    private static final DataType APPLE_DATA_TYPE = DataType.fromType(Apple.class);
    private static final DataType BANANA_DATA_TYPE = DataType.fromType(Banana.class);
    private static final ConverterFilter filter = new TypeMatchingVertexesFilter();

    @Test
    public void sameListIsReturnedIfNoMatch() throws Exception {
        Converter stringToOrange = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToOrange")).from(DataType.STRING)).to(ORANGE_DATA_TYPE)).build();
        Converter bananaToApple = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("bananaToApple")).from(BANANA_DATA_TYPE)).to(APPLE_DATA_TYPE)).build();
        List<Converter> converters = Arrays.asList(stringToOrange, bananaToApple);
        List filtered = filter.filter(converters, PEACH_DATA_TYPE, SEED_DATA_TYPE);
        MatcherAssert.assertThat((Object)filtered, (Matcher)Is.is((Matcher)Matchers.equalTo(converters)));
    }

    @Test
    public void matchingSourceTypeConvertersAreReturned() throws Exception {
        Converter stringToOrange = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToOrange")).from(DataType.STRING)).to(ORANGE_DATA_TYPE)).build();
        Converter bananaToApple = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("bananaToApple")).from(BANANA_DATA_TYPE)).to(APPLE_DATA_TYPE)).build();
        Converter stringToSeed = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToSeed")).from(DataType.STRING)).to(SEED_DATA_TYPE)).build();
        List<Converter> converters = Arrays.asList(stringToOrange, bananaToApple, stringToSeed);
        List filtered = filter.filter(converters, DataType.STRING, PEACH_DATA_TYPE);
        MatcherAssert.assertThat((Object)filtered, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)filtered, (Matcher)Matchers.contains((Object[])new Converter[]{stringToOrange, stringToSeed}));
    }

    @Test
    public void matchingSourceTypeConvertersAreReturnedEvenWithSuperTypesPresent() throws Exception {
        Converter stringToOrange = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToOrange")).from(DataType.STRING)).to(ORANGE_DATA_TYPE)).build();
        Converter objectToApple = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("objectToApple")).from(DataType.OBJECT)).to(APPLE_DATA_TYPE)).build();
        Converter stringToSeed = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToSeed")).from(DataType.STRING)).to(SEED_DATA_TYPE)).build();
        List<Converter> converters = Arrays.asList(stringToOrange, objectToApple, stringToSeed);
        List filtered = filter.filter(converters, DataType.STRING, PEACH_DATA_TYPE);
        MatcherAssert.assertThat((Object)filtered, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)filtered, (Matcher)Matchers.contains((Object[])new Converter[]{stringToOrange, stringToSeed}));
    }

    @Test
    public void matchingResultTypeConvertersAreReturned() throws Exception {
        Converter stringToOrange = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToOrange")).from(DataType.STRING)).to(ORANGE_DATA_TYPE)).build();
        Converter objectToApple = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("objectToApple")).from(DataType.OBJECT)).to(APPLE_DATA_TYPE)).build();
        Converter stringToSeed = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToSeed")).from(DataType.STRING)).to(SEED_DATA_TYPE)).build();
        List<Converter> converters = Arrays.asList(stringToOrange, objectToApple, stringToSeed);
        List filtered = filter.filter(converters, SEED_DATA_TYPE, ORANGE_DATA_TYPE);
        MatcherAssert.assertThat((Object)filtered, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)filtered, (Matcher)Matchers.contains((Object[])new Converter[]{stringToOrange}));
    }

    @Test
    public void bothVertexesMatchingIsBetterThanJustOne() throws Exception {
        Converter stringToOrange = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToOrange")).from(DataType.STRING)).to(ORANGE_DATA_TYPE)).build();
        Converter stringToBanana = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToBanana")).from(DataType.STRING)).to(BANANA_DATA_TYPE)).build();
        Converter seedToOrange = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("seedToOrange")).from(SEED_DATA_TYPE)).to(ORANGE_DATA_TYPE)).build();
        List<Converter> converters = Arrays.asList(stringToOrange, stringToBanana, seedToOrange);
        List filtered = filter.filter(converters, DataType.STRING, ORANGE_DATA_TYPE);
        MatcherAssert.assertThat((Object)filtered, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)filtered, (Matcher)Matchers.contains((Object[])new Converter[]{stringToOrange}));
    }

    @Test
    public void resultMimeTypeIsFiltered() throws Exception {
        Converter bananaToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("BananaToString")).from(BANANA_DATA_TYPE)).to(DataType.STRING)).build();
        Converter bananaToJsonString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("BananaToJsonString")).from(BANANA_DATA_TYPE)).to(DataType.JSON_STRING)).build();
        List<Converter> converters = Arrays.asList(bananaToString, bananaToJsonString);
        List filtered = filter.filter(converters, BANANA_DATA_TYPE, DataType.JSON_STRING);
        MatcherAssert.assertThat((Object)filtered, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)filtered, (Matcher)Matchers.contains((Object[])new Converter[]{bananaToJsonString}));
    }
}

