/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamProvider;
import org.mule.runtime.core.internal.transformer.simple.InputStreamToByteArray;
import org.mule.tck.core.streaming.SimpleByteBufferManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class InputStreamToByteArrayTestCase
extends AbstractMuleTestCase {
    private static final String DONKEY = "donkey";
    private InputStreamToByteArray transformer = new InputStreamToByteArray();

    @Test
    public void transformInputStream() throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(DONKEY.getBytes());
        Assert.assertThat((Object)this.transformer.transform((Object)inputStream), (Matcher)CoreMatchers.equalTo((Object)DONKEY.getBytes()));
    }

    @Test
    public void transformCursorStreamProvider() throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(DONKEY.getBytes());
        InMemoryCursorStreamProvider provider = new InMemoryCursorStreamProvider((InputStream)inputStream, InMemoryCursorStreamConfig.getDefault(), (ByteBufferManager)new SimpleByteBufferManager());
        Assert.assertThat((Object)this.transformer.transform((Object)provider), (Matcher)CoreMatchers.equalTo((Object)DONKEY.getBytes()));
    }
}

