/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.internal.transformer.simple.LocalDateToDate;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class LocalDateToDateTestCase
extends AbstractMuleContextTestCase {
    private LocalDateToDate transformer;

    protected void doSetUp() throws Exception {
        this.transformer = new LocalDateToDate();
        this.transformer.setMuleContext(muleContext);
    }

    @Test
    public void localDateToDate() throws Exception {
        LocalDate localDate = LocalDate.of(1983, 4, 20);
        Date date = (Date)this.transformer.transform((Object)localDate);
        this.assertEquals(localDate.atTime(0, 0), date);
    }

    @Test
    public void localDateTimeToDate() throws Exception {
        LocalDateTime localDateTime = LocalDateTime.of(1983, 4, 20, 21, 15);
        Date date = (Date)this.transformer.transform((Object)localDateTime);
        this.assertEquals(localDateTime, date);
    }

    private void assertEquals(LocalDateTime dateTime, Date date) {
        Assert.assertThat((Object)dateTime.atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli(), (Matcher)CoreMatchers.equalTo((Object)date.getTime()));
    }
}

