/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.transformer.simple.ObjectToInputStream;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class ObjectToInputStreamTestCase
extends AbstractMuleContextTestCase {
    private ObjectToInputStream transformer;

    protected void doSetUp() throws Exception {
        this.transformer = new ObjectToInputStream();
        this.transformer.setMuleContext(muleContext);
    }

    @Test
    public void testTransformString() throws TransformerException, IOException {
        Assert.assertTrue((boolean)InputStream.class.isAssignableFrom(this.transformer.transform((Object)"Test Message").getClass()));
        Assert.assertTrue((boolean)ObjectToInputStreamTestCase.compare(new ByteArrayInputStream("Test Message".getBytes()), (InputStream)this.transformer.transform((Object)"Test Message")));
    }

    @Test
    public void testTransformByteArray() throws TransformerException, IOException {
        Assert.assertTrue((boolean)InputStream.class.isAssignableFrom(this.transformer.transform((Object)"Test Message".getBytes()).getClass()));
        Assert.assertTrue((boolean)ObjectToInputStreamTestCase.compare(new ByteArrayInputStream("Test Message".getBytes()), (InputStream)this.transformer.transform((Object)"Test Message")));
    }

    @Test
    public void testTransformInputStream() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("Test Message".getBytes());
        try {
            Assert.assertEquals((Object)inputStream, (Object)this.transformer.transform((Object)inputStream));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof TransformerException));
            Assert.assertTrue((boolean)e.getMessage().contains("does not support source type"));
        }
    }

    @Test
    public void testTransformSerializable() {
        Apple apple = new Apple();
        ByteArrayInputStream serializedApple = new ByteArrayInputStream(muleContext.getObjectSerializer().getExternalProtocol().serialize((Object)apple));
        try {
            Assert.assertTrue((boolean)ObjectToInputStreamTestCase.compare(serializedApple, (InputStream)this.transformer.transform((Object)apple)));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof TransformerException));
            Assert.assertTrue((boolean)e.getMessage().contains("does not support source type"));
        }
    }

    public static boolean compare(InputStream input1, InputStream input2) {
        byte[] bytes1 = IOUtils.toByteArray((InputStream)input1);
        byte[] bytes2 = IOUtils.toByteArray((InputStream)input2);
        return Arrays.equals(bytes1, bytes2);
    }
}

