/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class RegistryTransformerLifecycleTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testLifecycleInTransientRegistry() throws Exception {
        TransformerLifecycleTracker transformer = new TransformerLifecycleTracker();
        transformer.setProperty("foo");
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)transformer);
        muleContext.dispose();
        this.assertRegistrationOnlyLifecycle(transformer);
    }

    @Test
    public void testLifecycleInFlowTransientRegistry() throws Exception {
        TransformerLifecycleTracker transformer = new TransformerLifecycleTracker();
        transformer.setProperty("foo");
        Flow flow = Flow.builder((String)"flow", (MuleContext)muleContext).processors(new Processor[]{transformer}).build();
        ((MuleContextWithRegistries)muleContext).getRegistry().registerFlowConstruct((FlowConstruct)flow);
        muleContext.dispose();
        this.assertLifecycle(transformer);
    }

    private void assertRegistrationOnlyLifecycle(TransformerLifecycleTracker transformer) {
        Assert.assertEquals((Object)"[setProperty, initialise]", (Object)transformer.getTracker().toString());
    }

    private void assertLifecycle(TransformerLifecycleTracker transformer) {
        Assert.assertEquals((Object)"[setProperty, initialise, dispose]", (Object)transformer.getTracker().toString());
    }

    public static class TransformerLifecycleTracker
    extends AbstractTransformer
    implements Disposable {
        private final List<String> tracker = new ArrayList<String>();
        private String property;

        protected Object doTransform(Object src, Charset encoding) throws TransformerException {
            this.tracker.add("doTransform");
            return null;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.tracker.add("setProperty");
        }

        public List<String> getTracker() {
            return this.tracker;
        }

        public void initialise() throws InitialisationException {
            this.tracker.add("initialise");
        }

        public void dispose() {
            this.tracker.add("dispose");
        }
    }
}

