/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.processor.simple.SetPayloadMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;

public class SetPayloadMessageProcessorTestCase
extends AbstractMuleContextTestCase {
    private static final String PLAIN_TEXT = "This is a plain text";
    private static final String EXPRESSION = "#[testVariable]";
    private static final Charset CUSTOM_ENCODING = StandardCharsets.UTF_16;
    private SetPayloadMessageProcessor setPayloadMessageProcessor;
    private MuleContext muleContext;
    private ExtendedExpressionManager expressionManager;

    @Before
    public void setUp() throws Exception {
        this.setPayloadMessageProcessor = new SetPayloadMessageProcessor();
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        this.setPayloadMessageProcessor.setMuleContext(this.muleContext);
        this.expressionManager = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
        Mockito.when((Object)this.muleContext.getExpressionManager()).thenReturn((Object)this.expressionManager);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn(Mockito.mock(MuleConfiguration.class));
        Mockito.when((Object)this.expressionManager.parse(Matchers.anyString(), (CoreEvent)Matchers.any(CoreEvent.class), (ComponentLocation)Matchers.any(ComponentLocation.class))).thenAnswer(invocation -> (String)invocation.getArguments()[0]);
    }

    @Test
    public void setsNullPayload() throws MuleException {
        this.setPayloadMessageProcessor.setValue(null);
        this.setPayloadMessageProcessor.initialise();
        CoreEvent response = this.setPayloadMessageProcessor.process(this.testEvent());
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void setsPlainText() throws MuleException {
        this.setPayloadMessageProcessor.setValue(PLAIN_TEXT);
        this.setPayloadMessageProcessor.initialise();
        Mockito.when((Object)this.expressionManager.isExpression(PLAIN_TEXT)).thenReturn((Object)false);
        CoreEvent response = this.setPayloadMessageProcessor.process(this.testEvent());
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)PLAIN_TEXT));
    }

    @Test
    public void setsExpressionPayload() throws MuleException {
        this.setPayloadMessageProcessor.setValue(EXPRESSION);
        Mockito.when((Object)this.expressionManager.isExpression(EXPRESSION)).thenReturn((Object)true);
        this.setPayloadMessageProcessor.initialise();
        TypedValue typedValue = new TypedValue((Object)PLAIN_TEXT, DataType.STRING);
        Mockito.when((Object)this.expressionManager.evaluate(EXPRESSION, this.testEvent())).thenReturn((Object)typedValue);
        Mockito.when((Object)this.expressionManager.evaluate((String)Matchers.eq((Object)EXPRESSION), (CoreEvent)Matchers.eq((Object)this.testEvent()), (CoreEvent.Builder)Matchers.any(CoreEvent.Builder.class), (ComponentLocation)Matchers.eq(null))).thenReturn((Object)typedValue);
        CoreEvent response = this.setPayloadMessageProcessor.process(this.testEvent());
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)PLAIN_TEXT));
    }

    @Test
    public void setsDefaultDataTypeForNullPayload() throws MuleException {
        this.setPayloadMessageProcessor.setValue(null);
        this.setPayloadMessageProcessor.initialise();
        CoreEvent response = this.setPayloadMessageProcessor.process(this.testEvent());
        Assert.assertThat((Object)response.getMessage().getPayload().getDataType(), (Matcher)DataTypeMatcher.like(Object.class, (MediaType)MediaType.ANY, null));
    }

    @Test
    public void setsDefaultDataTypeForNonNullValue() throws MuleException {
        this.setPayloadMessageProcessor.setValue(PLAIN_TEXT);
        this.setPayloadMessageProcessor.initialise();
        this.setPayloadMessageProcessor.process(this.testEvent());
        Assert.assertThat((Object)this.testEvent().getMessage().getPayload().getDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.ANY, null));
    }

    @Test
    public void setsCustomEncoding() throws MuleException {
        this.setPayloadMessageProcessor.setValue(PLAIN_TEXT);
        this.setPayloadMessageProcessor.setDataType(DataType.builder().charset(CUSTOM_ENCODING).build());
        this.setPayloadMessageProcessor.initialise();
        CoreEvent response = this.setPayloadMessageProcessor.process(this.testEvent());
        Assert.assertThat((Object)response.getMessage().getPayload().getDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.ANY, (Charset)CUSTOM_ENCODING));
    }

    @Test
    public void setsCustomMimeType() throws MuleException {
        this.setPayloadMessageProcessor.setValue(PLAIN_TEXT);
        this.setPayloadMessageProcessor.setDataType(DataType.builder().mediaType(MediaType.APPLICATION_XML).build());
        this.setPayloadMessageProcessor.initialise();
        CoreEvent response = this.setPayloadMessageProcessor.process(this.testEvent());
        Assert.assertThat((Object)response.getMessage().getPayload().getDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.APPLICATION_XML, null));
    }
}

