/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.simple.StringToBoolean;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StringToBooleanTestCase
extends AbstractMuleTestCase {
    private StringToBoolean transformer = new StringToBoolean();

    @Test
    public void validTransforms() {
        this.assertBoolean(true, "true", "TRUE", "trUE ", "yes", "1");
        this.assertBoolean(false, "false", "FALSE", "no ", "NO ", "0");
    }

    @Test(expected=TransformerException.class)
    public void invalidValue() throws Exception {
        this.transformer.transform((Object)"cuchurrumin");
    }

    private void assertBoolean(boolean expected, String ... values) {
        Stream.of(values).forEach(value -> {
            try {
                Assert.assertThat((Object)this.transformer.transform(value), (Matcher)CoreMatchers.is((Object)expected));
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

