/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.type;

import java.io.InputStream;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.api.metadata.FunctionDataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.metadata.DefaultCollectionDataType;
import org.mule.runtime.core.internal.metadata.DefaultFunctionDataType;
import org.mule.runtime.core.internal.metadata.DefaultMapDataType;
import org.mule.runtime.core.internal.metadata.SimpleDataType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.DataTypeCompatibilityMatcher;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.report.HeapDumpOnFailure;

public class DataTypeBuilderTestCase
extends AbstractMuleTestCase {
    private static final int GC_POLLING_TIMEOUT = 10000;
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Rule
    public HeapDumpOnFailure heapDumpOnFailure = new HeapDumpOnFailure();

    @Test
    public void buildSimple() {
        DataType dataType = DataType.fromType(String.class);
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(SimpleDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(String.class)));
    }

    @Test
    public void buildCollection() {
        DataType dataType = DataType.fromType(Set.class);
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(DefaultCollectionDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(Set.class)));
        Assert.assertThat((Object)((DefaultCollectionDataType)dataType).getItemDataType(), (Matcher)CoreMatchers.is((Object)DataType.OBJECT));
    }

    @Test
    public void buildFunction() {
        FunctionDataType dataType = (FunctionDataType)DataType.fromFunction((ExpressionFunction)new SomeFunction());
        Assert.assertThat((Object)dataType.getReturnType().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(dataType.getReturnType().get(), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        Assert.assertThat((Object)dataType.getParameters(), (Matcher)Matchers.hasSize((int)2));
        FunctionParameter first = (FunctionParameter)dataType.getParameters().get(0);
        Assert.assertThat((Object)first.getName(), (Matcher)CoreMatchers.is((Object)"fst"));
        Assert.assertThat((Object)first.getType(), (Matcher)CoreMatchers.equalTo((Object)DataType.NUMBER));
        Assert.assertThat((Object)first.getDefaultValueResolver(), (Matcher)Matchers.nullValue());
        FunctionParameter second = (FunctionParameter)dataType.getParameters().get(1);
        Assert.assertThat((Object)second.getName(), (Matcher)CoreMatchers.is((Object)"snd"));
        Assert.assertThat((Object)second.getType(), (Matcher)CoreMatchers.equalTo((Object)DataType.OBJECT));
        Assert.assertThat((Object)second.getDefaultValueResolver().getDefaultValue(BindingContext.builder().build()), (Matcher)CoreMatchers.is((Object)"wow"));
    }

    @Test
    public void buildMap() {
        DataType dataType = DataType.fromType(HashMap.class);
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(DefaultMapDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(HashMap.class)));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getKeyDataType(), (Matcher)CoreMatchers.is((Object)DataType.OBJECT));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getValueDataType(), (Matcher)CoreMatchers.is((Object)DataType.OBJECT));
    }

    @Test
    public void buildTypedCollection() {
        DataType dataType = DataType.builder().collectionType(List.class).itemType(String.class).itemMediaType(MediaType.APPLICATION_JSON).build();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(DefaultCollectionDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(List.class)));
        DataType itemDataType = ((DefaultCollectionDataType)dataType).getItemDataType();
        Assert.assertThat((Object)itemDataType.getType(), (Matcher)CoreMatchers.equalTo(String.class));
        Assert.assertThat((Object)itemDataType.getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.APPLICATION_JSON));
    }

    @Test
    public void buildTypedMap() {
        DataType dataType = DataType.builder().mapType(HashMap.class).keyType(Number.class).keyMediaType(MediaType.APPLICATION_JAVA).valueType(String.class).valueMediaType(MediaType.APPLICATION_JSON).build();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(DefaultMapDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(HashMap.class)));
        DataType keyDataType = ((DefaultMapDataType)dataType).getKeyDataType();
        Assert.assertThat((Object)keyDataType.getType(), (Matcher)CoreMatchers.equalTo(Number.class));
        Assert.assertThat((Object)keyDataType.getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.APPLICATION_JAVA));
        DataType valueDataType = ((DefaultMapDataType)dataType).getValueDataType();
        Assert.assertThat((Object)valueDataType.getType(), (Matcher)CoreMatchers.equalTo(String.class));
        Assert.assertThat((Object)valueDataType.getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.APPLICATION_JSON));
    }

    @Test
    public void buildTypedCollectionFromImplementationClass() {
        DataType dataType = DataType.builder().collectionType(SpecificCollection.class).build();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(DefaultCollectionDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(SpecificCollection.class)));
        Assert.assertThat((Object)((DefaultCollectionDataType)dataType).getItemDataType(), (Matcher)CoreMatchers.is((Object)DataType.STRING));
    }

    @Test
    public void buildTypedMapFromImplementationClass() {
        DataType dataType = DataType.builder().mapType(SpecificMap.class).build();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(DefaultMapDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(SpecificMap.class)));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getKeyDataType(), (Matcher)CoreMatchers.is((Object)DataType.STRING));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getValueDataType(), (Matcher)CoreMatchers.is((Object)DataType.NUMBER));
    }

    @Test
    public void templateSimple() {
        DataType template = DataType.builder().type(String.class).mediaType("text/plain;charset=ASCII").build();
        DataType dataType = DataType.builder((DataType)template).build();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(SimpleDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(String.class)));
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"text"));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"plain"));
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.US_ASCII));
    }

    @Test
    public void templateCollection() {
        DataType template = DataType.builder().type(Set.class).mediaType("text/plain;charset=ASCII").build();
        DataType dataType = DataType.builder((DataType)template).build();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(DefaultCollectionDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(Set.class)));
        Assert.assertThat((Object)((DefaultCollectionDataType)dataType).getItemDataType(), (Matcher)CoreMatchers.is((Object)DataType.OBJECT));
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"text"));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"plain"));
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.US_ASCII));
    }

    @Test
    public void templateTypedCollection() {
        DataType template = DataType.builder().collectionType(List.class).itemType(String.class).itemMediaType("application/json;charset=UTF-8").mediaType("text/plain;charset=ASCII").build();
        DataType dataType = DataType.builder((DataType)template).build();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(DefaultCollectionDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(List.class)));
        Assert.assertThat((Object)((DefaultCollectionDataType)dataType).getItemDataType(), (Matcher)CoreMatchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.STRING)));
        Assert.assertThat((Object)((DefaultCollectionDataType)dataType).getItemDataType().getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"application"));
        Assert.assertThat((Object)((DefaultCollectionDataType)dataType).getItemDataType().getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"json"));
        Assert.assertThat(((DefaultCollectionDataType)dataType).getItemDataType().getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"text"));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"plain"));
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.US_ASCII));
    }

    @Test
    public void templateMap() {
        DataType template = DataType.builder().type(HashMap.class).mediaType("text/plain;charset=ASCII").build();
        DataType dataType = DataType.builder((DataType)template).build();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(DefaultMapDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(HashMap.class)));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getKeyDataType(), (Matcher)CoreMatchers.is((Object)DataType.OBJECT));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getValueDataType(), (Matcher)CoreMatchers.is((Object)DataType.OBJECT));
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"text"));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"plain"));
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.US_ASCII));
    }

    @Test
    public void templateTypedMap() {
        DataType template = DataType.builder().mapType(HashMap.class).keyType(String.class).keyMediaType("text/plain;charset=UTF-8").valueType(Number.class).valueMediaType("application/json;charset=ISO-8859-1").mediaType("text/plain;charset=ASCII").build();
        DataType dataType = DataType.builder((DataType)template).build();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(DefaultMapDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(HashMap.class)));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getKeyDataType(), (Matcher)CoreMatchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.TEXT_STRING)));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getKeyDataType().getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"text"));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getKeyDataType().getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"plain"));
        Assert.assertThat(((DefaultMapDataType)dataType).getKeyDataType().getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getValueDataType(), (Matcher)CoreMatchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.NUMBER)));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getValueDataType().getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"application"));
        Assert.assertThat((Object)((DefaultMapDataType)dataType).getValueDataType().getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"json"));
        Assert.assertThat(((DefaultMapDataType)dataType).getValueDataType().getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.ISO_8859_1));
    }

    @Test
    public void templateFunction() {
        FunctionParameter functionParameter = new FunctionParameter("fst", DataType.NUMBER);
        DataType template = DataType.builder().functionType(SomeFunction.class).returnType(DataType.STRING).parametersType(Collections.singletonList(functionParameter)).build();
        DataType dataType = DataType.builder((DataType)template).build();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(DefaultFunctionDataType.class));
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(SomeFunction.class)));
        Assert.assertThat(((DefaultFunctionDataType)dataType).getReturnType().get(), (Matcher)CoreMatchers.is((Object)DataType.STRING));
        Assert.assertThat((Object)((DefaultFunctionDataType)dataType).getParameters(), (Matcher)Matchers.hasItems((Object[])new FunctionParameter[]{functionParameter}));
    }

    @Test
    public void proxy() {
        Class<?> muleMessageProxy = Proxy.getProxyClass(DataTypeBuilderTestCase.class.getClassLoader(), Message.class);
        DataType dataType = DataType.fromType(muleMessageProxy);
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(Message.class)));
    }

    @Test
    public void cglibInterfaceProxy() {
        Message muleMessageProxy = (Message)Mockito.mock(Message.class);
        DataType dataType = DataType.fromObject((Object)muleMessageProxy);
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(Message.class)));
    }

    @Test
    public void cglibClassProxy() {
        Message muleMessageProxy = (Message)Mockito.mock(MessageTestImpl.class);
        DataType dataType = DataType.fromObject((Object)muleMessageProxy);
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(MessageTestImpl.class)));
    }

    @Test
    public void cglibSpyProxy() {
        Message muleMessageProxy = (Message)Mockito.spy((Object)new MessageTestImpl());
        DataType dataType = DataType.fromObject((Object)muleMessageProxy);
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(MessageTestImpl.class)));
    }

    @Test
    public void mimeTypeWithEncoding() {
        DataType dataType = DataType.builder().mediaType("text/plain;charset=ASCII").build();
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"text"));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"plain"));
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.US_ASCII));
    }

    @Test
    public void invalidMimeType() {
        this.expected.expect(IllegalArgumentException.class);
        DataType dataType = DataType.builder().mediaType("imInvalid").build();
    }

    @Test
    public void invalidEncoding() {
        this.expected.expect(IllegalArgumentException.class);
        DataType dataType = DataType.builder().charset("imInvalid").build();
    }

    @Test
    public void recycleBuilder() {
        DataTypeParamsBuilder builder = DataType.builder().type(String.class);
        builder.build();
        this.expected.expect(IllegalStateException.class);
        builder.build();
    }

    @Test
    public void cachedInstances() {
        DataTypeParamsBuilder builder1 = DataType.builder().type(String.class);
        DataTypeParamsBuilder builder2 = DataType.builder().type(String.class);
        Assert.assertThat((Object)builder1, (Matcher)CoreMatchers.equalTo((Object)builder2));
        Assert.assertThat((Object)builder1.build(), (Matcher)CoreMatchers.sameInstance((Object)builder2.build()));
    }

    @Test
    public void cacheClean() throws InterruptedException, ClassNotFoundException {
        ClassLoader custom = new ClassLoader(((Object)((Object)this)).getClass().getClassLoader()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (Message.class.getName().equals(name)) {
                    try {
                        byte[] classBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/org/mule/runtime/api/message/Message.class"));
                        return this.defineClass(null, classBytes, 0, classBytes.length);
                    }
                    catch (Exception e) {
                        return super.loadClass(name);
                    }
                }
                return super.loadClass(name);
            }
        };
        PhantomReference<1> clRef = new PhantomReference<1>(custom, new ReferenceQueue());
        DataType.builder().type(custom.loadClass(Message.class.getName())).build();
        custom = null;
        new PollingProber(10000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            System.gc();
            Assert.assertThat((Object)clRef.isEnqueued(), (Matcher)CoreMatchers.is((Object)true));
            return true;
        }, "A hard reference is being mantained to the type of the DataType."));
    }

    private class SomeFunction
    implements ExpressionFunction {
        private SomeFunction() {
        }

        public Object call(Object[] objects, BindingContext bindingContext) {
            return null;
        }

        public Optional<DataType> returnType() {
            return Optional.of(DataType.STRING);
        }

        public List<FunctionParameter> parameters() {
            ArrayList<FunctionParameter> parameters = new ArrayList<FunctionParameter>();
            parameters.add(new FunctionParameter("fst", DataType.NUMBER));
            parameters.add(new FunctionParameter("snd", DataType.OBJECT, ctx -> "wow"));
            return parameters;
        }
    }

    private class SpecificCollection
    extends LinkedList<String> {
        private SpecificCollection() {
        }
    }

    private class SpecificMap
    extends HashMap<String, Number> {
        private SpecificMap() {
        }
    }

    private static class MessageTestImpl
    implements Message {
        private MessageTestImpl() {
        }

        public <T> TypedValue<T> getPayload() {
            return null;
        }

        public <T> TypedValue<T> getAttributes() {
            return null;
        }
    }
}

