/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.type;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.internal.metadata.DefaultCollectionDataType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DataTypeFactoryTestCase
extends AbstractMuleTestCase {
    private final Charset encoding = StandardCharsets.UTF_16;
    private final String mimeType = "application/json";
    private final Class<String> type = String.class;

    @Test
    public void createsDataTypeForNullPayload() throws Exception {
        DataType dataType = DataType.fromObject(null);
        MatcherAssert.assertThat((Object)dataType, (Matcher)DataTypeMatcher.like(Object.class, (MediaType)MediaType.ANY, null));
    }

    @Test
    public void createsDataTypeForNonNullObject() throws Exception {
        DataType dataType = DataType.fromObject((Object)"test");
        MatcherAssert.assertThat((Object)dataType, (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.ANY, null));
    }

    @Test
    public void mimeTypeWithEncodingInformation() throws Exception {
        DataType dataType = DataType.builder().type(this.type).mediaType(String.format("%s; charset=UTF-8", "application/json")).charset(this.encoding).build();
        MatcherAssert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.equalTo(this.type));
        MatcherAssert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"application/json".split("/")[0]));
        MatcherAssert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"application/json".split("/")[1]));
        MatcherAssert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)this.encoding));
    }

    @Test
    public void createsDataTypeForNonCollection() {
        DataType dataType = DataType.builder().collectionType(List.class).itemType(this.type).itemMediaType("application/json").build();
        MatcherAssert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.equalTo(List.class));
        MatcherAssert.assertThat((Object)dataType, (Matcher)IsInstanceOf.instanceOf(DefaultCollectionDataType.class));
        DataType itemDataType = ((DefaultCollectionDataType)dataType).getItemDataType();
        MatcherAssert.assertThat((Object)itemDataType.getType(), (Matcher)CoreMatchers.equalTo(this.type));
        MatcherAssert.assertThat((Object)itemDataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"application/json".split("/")[0]));
        MatcherAssert.assertThat((Object)itemDataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"application/json".split("/")[1]));
    }
}

