/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.type;

import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.DataTypeCompatibilityMatcher;

public class DataTypeMatchingTestCase
extends AbstractMuleTestCase {
    private static final MediaType STAR_STAR_MEDIA_TYPE = MediaType.ANY;
    private static final MediaType APPLICATION_JSON_MEDIA_TYPE = MediaType.APPLICATION_JSON;
    private static final MediaType TEXT_MEDIA_TYPE = MediaType.TEXT;
    private static final MediaType FOO_MEDIA_TYPE = MediaType.create((String)"foo", (String)"foo");
    private static final DataType GENERIC_DATA_TYPE = DataType.builder().type(Object.class).mediaType(STAR_STAR_MEDIA_TYPE).build();
    private static final DataType GENERIC_TYPE_GENERIC_DATA_TYPE = DataType.builder().type(Object.class).mediaType(FOO_MEDIA_TYPE).build();
    private static final DataType GENERIC_MEDIA_TYPE_GENERIC_DATA_TYPE = DataType.builder().type(FOO.class).mediaType(STAR_STAR_MEDIA_TYPE).build();
    private static final DataType JSON_PARENT_DATA_TYPE = DataType.builder().type(JSON_PARENT.class).mediaType(APPLICATION_JSON_MEDIA_TYPE).build();
    private static final DataType JSON_SON_DATA_TYPE = DataType.builder().type(JSON_SON.class).mediaType(APPLICATION_JSON_MEDIA_TYPE).build();
    private static final DataType TEXT_DATA_TYPE = DataType.builder().type(TEXT.class).mediaType(TEXT_MEDIA_TYPE).build();
    private static final DataType[] dataTypes = new DataType[]{GENERIC_DATA_TYPE, GENERIC_TYPE_GENERIC_DATA_TYPE, GENERIC_MEDIA_TYPE_GENERIC_DATA_TYPE, JSON_PARENT_DATA_TYPE, JSON_SON_DATA_TYPE, TEXT_DATA_TYPE};

    @Test
    public void sameDataTypeIsEqualsToItself() throws Exception {
        for (int i = 0; i < dataTypes.length; ++i) {
            MatcherAssert.assertThat((Object)dataTypes[i], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)dataTypes[i])));
        }
    }

    @Test
    public void sameDataTypeIsCompatibleWithItself() throws Exception {
        for (int i = 0; i < dataTypes.length; ++i) {
            MatcherAssert.assertThat((Object)dataTypes[i], (Matcher)Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)dataTypes[i])));
        }
    }

    @Test
    public void allDataTypesAreDifferent() throws Exception {
        for (int i = 0; i < dataTypes.length; ++i) {
            for (int j = 0; j < dataTypes.length; ++j) {
                if (i == j) continue;
                MatcherAssert.assertThat((Object)dataTypes[i], (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)dataTypes[j]))));
                MatcherAssert.assertThat((Object)dataTypes[j], (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)dataTypes[i]))));
            }
        }
    }

    @Test
    public void genericDataTypeShouldBeCompatibleWithEveryDataType() throws Exception {
        MatcherAssert.assertThat((Object)JSON_PARENT_DATA_TYPE, (Matcher)Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)GENERIC_DATA_TYPE)));
        MatcherAssert.assertThat((Object)JSON_SON_DATA_TYPE, (Matcher)Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)GENERIC_DATA_TYPE)));
        MatcherAssert.assertThat((Object)TEXT_DATA_TYPE, (Matcher)Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)GENERIC_DATA_TYPE)));
        MatcherAssert.assertThat((Object)GENERIC_TYPE_GENERIC_DATA_TYPE, (Matcher)Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)GENERIC_DATA_TYPE)));
        MatcherAssert.assertThat((Object)GENERIC_MEDIA_TYPE_GENERIC_DATA_TYPE, (Matcher)Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)GENERIC_DATA_TYPE)));
    }

    @Test
    public void noDataTypeShouldBeCompatibleWithTheGenericOne() throws Exception {
        MatcherAssert.assertThat((Object)GENERIC_DATA_TYPE, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)JSON_PARENT_DATA_TYPE))));
        MatcherAssert.assertThat((Object)GENERIC_DATA_TYPE, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)JSON_SON_DATA_TYPE))));
        MatcherAssert.assertThat((Object)GENERIC_DATA_TYPE, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)TEXT_DATA_TYPE))));
    }

    @Test
    public void nonGenericDataTypesShouldNotBeCompatible() throws Exception {
        MatcherAssert.assertThat((Object)JSON_PARENT_DATA_TYPE, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)TEXT_DATA_TYPE))));
        MatcherAssert.assertThat((Object)TEXT_DATA_TYPE, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)JSON_PARENT_DATA_TYPE))));
        MatcherAssert.assertThat((Object)JSON_SON_DATA_TYPE, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)TEXT_DATA_TYPE))));
        MatcherAssert.assertThat((Object)TEXT_DATA_TYPE, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)JSON_SON_DATA_TYPE))));
    }

    @Test
    public void inheritedTypeDataTypesShouldBeCompatibleOneWay() throws Exception {
        MatcherAssert.assertThat((Object)JSON_PARENT_DATA_TYPE, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)JSON_SON_DATA_TYPE))));
        MatcherAssert.assertThat((Object)JSON_SON_DATA_TYPE, (Matcher)Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)JSON_PARENT_DATA_TYPE)));
    }

    @Test
    public void ifCharsetItsNotSpecifiedItShouldBeCompatibleWithAny() throws Exception {
        DataType jsonWithCharset = DataType.builder((DataType)JSON_PARENT_DATA_TYPE).charset(StandardCharsets.UTF_8).build();
        MatcherAssert.assertThat((Object)JSON_PARENT_DATA_TYPE, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)jsonWithCharset))));
        MatcherAssert.assertThat((Object)jsonWithCharset, (Matcher)Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)JSON_PARENT_DATA_TYPE)));
    }

    @Test
    public void differentCharsetsShouldNotBeCompatible() throws Exception {
        DataType jsonUtf8 = DataType.builder((DataType)JSON_PARENT_DATA_TYPE).charset(StandardCharsets.UTF_8).build();
        DataType jsonUtf16 = DataType.builder((DataType)JSON_PARENT_DATA_TYPE).charset(StandardCharsets.UTF_16).build();
        MatcherAssert.assertThat((Object)jsonUtf8, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)jsonUtf16))));
        MatcherAssert.assertThat((Object)jsonUtf16, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)jsonUtf8))));
    }

    private static class FOO {
        private FOO() {
        }
    }

    private static class TEXT {
        private TEXT() {
        }
    }

    private static class JSON_SON
    extends JSON_PARENT {
        private JSON_SON() {
        }
    }

    private static class JSON_PARENT {
        private JSON_PARENT() {
        }
    }
}

