/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.type;

import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class SimpleDataTypeTestCase
extends AbstractMuleTestCase {
    @Test
    public void acceptsSupportedEncoding() throws Exception {
        DataType dataType = DataType.builder().charset(StandardCharsets.UTF_8.name()).build();
        MatcherAssert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)Matchers.equalTo((Object)StandardCharsets.UTF_8));
    }

    @Test(expected=UnsupportedCharsetException.class)
    public void rejectsUnsupportedEncoding() throws Exception {
        DataType.builder().charset("unsupportedEncoding").build();
    }

    @Test
    public void acceptsValidMimeType() throws Exception {
        DataType dataType = DataType.builder().mediaType(MediaType.JSON).build();
        MatcherAssert.assertThat((Object)dataType.getMediaType(), (Matcher)Matchers.equalTo((Object)MediaType.JSON));
    }

    @Test(expected=IllegalArgumentException.class)
    public void rejectsValidMimeType() throws Exception {
        DataType.builder().mediaType("invalidMimeType").build();
    }
}

