/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.tck.classlaoder.TestClassLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.EnumerationMatcher;

@SmallTest
public class CompositeClassLoaderTestCase
extends AbstractMuleTestCase {
    private static final String CLASS_NAME = "java.lang.Object";
    private static final Class APP_LOADED_CLASS = Object.class;
    private static final Class PLUGIN_LOADED_CLASS = String.class;
    private static final String RESOURCE_NAME = "dummy.txt";
    private static final String PLUGIN_RESOURCE_NAME = "plugin.txt";
    private final URL APP_LOADED_RESOURCE;
    private final URL PLUGIN_LOADED_RESOURCE;
    private final InputStream APP_LOADED_STREAM_RESOURCE = (InputStream)Mockito.mock(InputStream.class);
    private final InputStream PLUGIN_LOADED_STREAM_RESOURCE = (InputStream)Mockito.mock(InputStream.class);
    private final TestClassLoader appClassLoader = new TestClassLoader(null);
    private final TestClassLoader pluginClassLoader = new TestClassLoader(null);

    public CompositeClassLoaderTestCase() throws MalformedURLException {
        this.APP_LOADED_RESOURCE = new URL("file:///app.txt");
        this.PLUGIN_LOADED_RESOURCE = new URL("file:///plugin.txt");
    }

    @Test
    public void loadsClassFromAppFirst() throws Exception {
        this.appClassLoader.addClass(CLASS_NAME, APP_LOADED_CLASS);
        this.pluginClassLoader.addClass(CLASS_NAME, PLUGIN_LOADED_CLASS);
        CompositeClassLoader compositeApplicationClassLoader = new CompositeClassLoader((ClassLoader)this.appClassLoader, new ClassLoader[]{this.pluginClassLoader});
        Class aClass = compositeApplicationClassLoader.loadClass(CLASS_NAME);
        Assert.assertThat((Object)aClass, (Matcher)Matchers.equalTo((Object)APP_LOADED_CLASS));
    }

    @Test
    public void loadsClassFromPluginWhenIsNotDefinedInApp() throws Exception {
        this.pluginClassLoader.addClass(CLASS_NAME, PLUGIN_LOADED_CLASS);
        CompositeClassLoader compositeApplicationClassLoader = new CompositeClassLoader((ClassLoader)this.appClassLoader, new ClassLoader[]{this.pluginClassLoader});
        Class aClass = compositeApplicationClassLoader.loadClass(CLASS_NAME);
        Assert.assertThat((Object)aClass, (Matcher)Matchers.equalTo((Object)PLUGIN_LOADED_CLASS));
    }

    @Test(expected=ClassNotFoundException.class)
    public void failsToLoadClassWhenIsNotDefinedInAnyClassLoader() throws Exception {
        CompositeClassLoader compositeApplicationClassLoader = new CompositeClassLoader((ClassLoader)this.appClassLoader, new ClassLoader[]{this.pluginClassLoader});
        compositeApplicationClassLoader.loadClass(CLASS_NAME);
    }

    @Test
    public void loadsResourceFromAppFirst() throws Exception {
        this.appClassLoader.addResource(RESOURCE_NAME, this.APP_LOADED_RESOURCE);
        this.pluginClassLoader.addResource(RESOURCE_NAME, this.PLUGIN_LOADED_RESOURCE);
        CompositeClassLoader compositeApplicationClassLoader = new CompositeClassLoader((ClassLoader)this.appClassLoader, new ClassLoader[]{this.pluginClassLoader});
        URL resource = compositeApplicationClassLoader.getResource(RESOURCE_NAME);
        Assert.assertThat((Object)resource, (Matcher)Matchers.equalTo((Object)this.APP_LOADED_RESOURCE));
    }

    @Test
    public void loadsResourceFromPluginWhenIsNotDefinedInApp() throws Exception {
        this.pluginClassLoader.addResource(RESOURCE_NAME, this.PLUGIN_LOADED_RESOURCE);
        CompositeClassLoader compositeApplicationClassLoader = new CompositeClassLoader((ClassLoader)this.appClassLoader, new ClassLoader[]{this.pluginClassLoader});
        URL resource = compositeApplicationClassLoader.getResource(RESOURCE_NAME);
        Assert.assertThat((Object)resource, (Matcher)Matchers.equalTo((Object)this.PLUGIN_LOADED_RESOURCE));
    }

    @Test
    public void returnsNullResourceWhenIsNotDefinedInAnyClassLoader() throws Exception {
        CompositeClassLoader compositeApplicationClassLoader = new CompositeClassLoader((ClassLoader)this.appClassLoader, new ClassLoader[]{this.pluginClassLoader});
        URL resource = compositeApplicationClassLoader.getResource(RESOURCE_NAME);
        Assert.assertThat((Object)resource, (Matcher)Matchers.equalTo(null));
    }

    @Test
    public void loadsStreamResourceFromAppFirst() throws Exception {
        this.appClassLoader.addStreamResource(RESOURCE_NAME, this.APP_LOADED_STREAM_RESOURCE);
        this.pluginClassLoader.addStreamResource(RESOURCE_NAME, this.PLUGIN_LOADED_STREAM_RESOURCE);
        CompositeClassLoader compositeApplicationClassLoader = new CompositeClassLoader((ClassLoader)this.appClassLoader, new ClassLoader[]{this.pluginClassLoader});
        InputStream resourceAsStream = compositeApplicationClassLoader.getResourceAsStream(RESOURCE_NAME);
        Assert.assertThat((Object)resourceAsStream, (Matcher)Matchers.equalTo((Object)this.APP_LOADED_STREAM_RESOURCE));
    }

    @Test
    public void loadsStreamResourceFromPluginWhenIsNotDefinedInApp() throws Exception {
        this.pluginClassLoader.addStreamResource(RESOURCE_NAME, this.PLUGIN_LOADED_STREAM_RESOURCE);
        CompositeClassLoader compositeApplicationClassLoader = new CompositeClassLoader((ClassLoader)this.appClassLoader, new ClassLoader[]{this.pluginClassLoader});
        InputStream resourceAsStream = compositeApplicationClassLoader.getResourceAsStream(RESOURCE_NAME);
        Assert.assertThat((Object)resourceAsStream, (Matcher)Matchers.equalTo((Object)this.PLUGIN_LOADED_STREAM_RESOURCE));
    }

    @Test
    public void returnsNullStreamResourceWhenIsNotDefinedInAnyClassLoader() throws Exception {
        CompositeClassLoader compositeApplicationClassLoader = new CompositeClassLoader((ClassLoader)this.appClassLoader, new ClassLoader[]{this.pluginClassLoader});
        InputStream resourceAsStream = compositeApplicationClassLoader.getResourceAsStream(RESOURCE_NAME);
        Assert.assertThat((Object)resourceAsStream, (Matcher)Matchers.equalTo(null));
    }

    @Test
    public void getsResourcesFromAppAndPluginClassLoader() throws Exception {
        this.appClassLoader.addResource(RESOURCE_NAME, this.APP_LOADED_RESOURCE);
        this.pluginClassLoader.addResource(PLUGIN_RESOURCE_NAME, this.PLUGIN_LOADED_RESOURCE);
        CompositeClassLoader compositeApplicationClassLoader = new CompositeClassLoader((ClassLoader)this.appClassLoader, new ClassLoader[]{this.pluginClassLoader});
        Enumeration resources = compositeApplicationClassLoader.getResources(RESOURCE_NAME);
        LinkedList<URL> expectedResources = new LinkedList<URL>();
        expectedResources.add(this.APP_LOADED_RESOURCE);
        expectedResources.add(this.PLUGIN_LOADED_RESOURCE);
        Assert.assertThat((Object)resources, (Matcher)EnumerationMatcher.equalTo(expectedResources));
    }

    @Test
    public void filtersResourcesDuplicatedInAppAndPluginClassLoader() throws Exception {
        this.appClassLoader.addResource(RESOURCE_NAME, this.APP_LOADED_RESOURCE);
        this.pluginClassLoader.addResource(RESOURCE_NAME, this.APP_LOADED_RESOURCE);
        CompositeClassLoader compositeApplicationClassLoader = new CompositeClassLoader((ClassLoader)this.appClassLoader, new ClassLoader[]{this.pluginClassLoader});
        Enumeration resources = compositeApplicationClassLoader.getResources(RESOURCE_NAME);
        LinkedList<URL> expectedResources = new LinkedList<URL>();
        expectedResources.add(this.APP_LOADED_RESOURCE);
        expectedResources.add(this.APP_LOADED_RESOURCE);
        Assert.assertThat((Object)resources, (Matcher)EnumerationMatcher.equalTo(expectedResources));
    }
}

