/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DataTypeUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void generatesContentTypeWithCharset() throws Exception {
        DataType dataType = DataType.builder().type(Object.class).mediaType(MediaType.APPLICATION_JSON).charset(StandardCharsets.UTF_8.name()).build();
        String contentType = dataType.getMediaType().toRfcString();
        MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.equalTo((Object)"application/json; charset=UTF-8"));
    }

    @Test
    public void generatesContentTypeWithoutCharset() throws Exception {
        DataType dataType = DataType.builder().type(Object.class).mediaType(MediaType.APPLICATION_JSON).build();
        String contentType = dataType.getMediaType().toRfcString();
        MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.equalTo((Object)"application/json"));
    }
}

