/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.transform.sax.SAXSource;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.streaming.iterator.Consumer;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.util.DefaultStreamCloserService;
import org.mule.runtime.core.internal.util.StreamCloser;
import org.mule.tck.size.SmallTest;
import org.xml.sax.InputSource;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultStreamCloserServiceTestCase {
    private DefaultStreamCloserService service;
    private MuleContextWithRegistries muleContext;

    @Before
    public void setUp() {
        this.muleContext = (MuleContextWithRegistries)Mockito.mock(MuleContextWithRegistries.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.service = new DefaultStreamCloserService();
        this.service.setMuleContext((MuleContext)this.muleContext);
    }

    @Test
    public void closeCoreTypes() throws Exception {
        ArrayList<Object> closeableMocks = new ArrayList<Object>();
        InputStream in = (InputStream)Mockito.mock(ByteArrayInputStream.class);
        closeableMocks.add(in);
        InputSource inputSource1 = (InputSource)Mockito.mock(InputSource.class);
        InputStream byteStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inputSource1.getByteStream()).thenReturn((Object)byteStream);
        closeableMocks.add(inputSource1);
        InputSource inputSource2 = (InputSource)Mockito.mock(InputSource.class);
        Reader reader = (Reader)Mockito.mock(Reader.class);
        Mockito.when((Object)inputSource2.getCharacterStream()).thenReturn((Object)reader);
        closeableMocks.add(inputSource2);
        SAXSource sax1 = (SAXSource)Mockito.mock(SAXSource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)sax1.getInputSource()).thenReturn((Object)inputSource1);
        closeableMocks.add(sax1);
        SAXSource sax2 = (SAXSource)Mockito.mock(SAXSource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)sax2.getInputSource()).thenReturn((Object)inputSource2);
        closeableMocks.add(sax2);
        Closeable closeable = (Closeable)Mockito.mock(Consumer.class);
        closeableMocks.add(closeable);
        Closeable javaClosable = (Closeable)Mockito.mock(Closeable.class);
        closeableMocks.add(javaClosable);
        Mockito.when((Object)this.muleContext.getRegistry().lookupObjects(StreamCloser.class)).thenReturn(new ArrayList());
        closeableMocks.forEach(arg_0 -> ((DefaultStreamCloserService)this.service).closeStream(arg_0));
        ((InputStream)Mockito.verify((Object)in)).close();
        ((InputStream)Mockito.verify((Object)byteStream, (VerificationMode)Mockito.times((int)2))).close();
        ((Reader)Mockito.verify((Object)reader, (VerificationMode)Mockito.times((int)2))).close();
        ((Closeable)Mockito.verify((Object)closeable)).close();
        ((Closeable)Mockito.verify((Object)javaClosable)).close();
    }

    @Test
    public void customCloser() throws Exception {
        StreamCloser closer = (StreamCloser)Mockito.mock(StreamCloser.class);
        Mockito.when((Object)closer.canClose(this.getClass())).thenReturn((Object)true);
        Mockito.when((Object)this.muleContext.getRegistry().lookupObjects(StreamCloser.class)).thenReturn(Arrays.asList(closer));
        this.service.closeStream((Object)this);
        ((StreamCloser)Mockito.verify((Object)closer)).close((Object)this);
    }
}

