/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.internal.util.OneTimeWarning;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.slf4j.Logger;

@SmallTest
public class OneTimeWarningTestCase
extends AbstractMuleTestCase {
    private static final int TIMEOUT = 5;

    @Test
    public void warn() throws Exception {
        String message = "Hello World!";
        Logger logger = (Logger)Mockito.mock(Logger.class);
        int competitors = 10;
        final CountDownLatch warnLatch = new CountDownLatch(10);
        final CountDownLatch completionLatch = new CountDownLatch(10);
        final OneTimeWarning warning = new OneTimeWarning(logger, message);
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        for (int i = 0; i < 10; ++i) {
            new Thread(){

                @Override
                public void run() {
                    warnLatch.countDown();
                    try {
                        warnLatch.await(5L, TimeUnit.SECONDS);
                    }
                    catch (Throwable t) {
                        exception.set(t);
                    }
                    warning.warn();
                    completionLatch.countDown();
                }
            }.start();
        }
        completionLatch.await(5L, TimeUnit.SECONDS);
        Assert.assertThat(exception.get(), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        ((Logger)Mockito.verify((Object)logger)).warn(message);
    }
}

