/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.core.internal.util.OrderedProperties;
import org.mule.tck.size.SmallTest;

@SmallTest
public class OrderedPropertiesTestCase {
    private final int count = 100;
    private Properties properties;
    private List<String> keys;
    private List<String> values;

    @Before
    public void setUp() {
        this.properties = new OrderedProperties();
        this.keys = new ArrayList<String>();
        this.values = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            String key = this.random();
            String value = this.random();
            this.keys.add(key);
            this.values.add(value);
            this.properties.setProperty(key, value);
        }
    }

    @Test
    public void orderedEntrySet() {
        int i = 0;
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            Assert.assertEquals((Object)this.keys.get(i), (Object)entry.getKey());
            Assert.assertEquals((Object)this.values.get(i), (Object)entry.getValue());
            ++i;
        }
    }

    @Test
    public void orderedPropertyNames() {
        int i = 0;
        Enumeration<?> propertyNames = this.properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Object key = propertyNames.nextElement();
            Assert.assertEquals((Object)this.keys.get(i), key);
            ++i;
        }
    }

    private String random() {
        return RandomStringUtils.randomAlphabetic((int)10);
    }
}

