/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.internal.util.VersionRange;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class VersionRangeTestCase
extends AbstractMuleTestCase {
    @Test
    public void testSingleVersionRange() {
        VersionRange vr = new VersionRange("[1.5.0_11,1.6)");
        Assert.assertNotNull((Object)vr);
        Assert.assertTrue((boolean)vr.isLowerBoundInclusive());
        Assert.assertFalse((boolean)vr.isUpperBoundInclusive());
        Assert.assertEquals((Object)"1.5.0_11", (Object)vr.getLowerVersion());
        Assert.assertEquals((Object)"1.6", (Object)vr.getUpperVersion());
        vr = new VersionRange("(1.5.0_11-b05,2.7.12]");
        Assert.assertNotNull((Object)vr);
        Assert.assertFalse((boolean)vr.isLowerBoundInclusive());
        Assert.assertTrue((boolean)vr.isUpperBoundInclusive());
        Assert.assertEquals((Object)"1.5.0_11-b05", (Object)vr.getLowerVersion());
        Assert.assertEquals((Object)"2.7.12", (Object)vr.getUpperVersion());
    }

    @Test
    public void testCreateVersionRanges() {
        List ranges = VersionRange.createVersionRanges((String)"(,1.4.2),[1.5.0_11,1.6),[1.7,]");
        Assert.assertNotNull((Object)ranges);
        Assert.assertEquals((long)3L, (long)ranges.size());
        VersionRange vr = (VersionRange)ranges.get(0);
        Assert.assertFalse((boolean)vr.isLowerBoundInclusive());
        Assert.assertFalse((boolean)vr.isUpperBoundInclusive());
        Assert.assertEquals((Object)"", (Object)vr.getLowerVersion());
        Assert.assertEquals((Object)"1.4.2", (Object)vr.getUpperVersion());
        vr = (VersionRange)ranges.get(1);
        Assert.assertTrue((boolean)vr.isLowerBoundInclusive());
        Assert.assertFalse((boolean)vr.isUpperBoundInclusive());
        Assert.assertEquals((Object)"1.5.0_11", (Object)vr.getLowerVersion());
        Assert.assertEquals((Object)"1.6", (Object)vr.getUpperVersion());
        vr = (VersionRange)ranges.get(2);
        Assert.assertTrue((boolean)vr.isLowerBoundInclusive());
        Assert.assertTrue((boolean)vr.isUpperBoundInclusive());
        Assert.assertEquals((Object)"1.7", (Object)vr.getLowerVersion());
        Assert.assertEquals((Object)"", (Object)vr.getUpperVersion());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidDelimiter() {
        VersionRange range = new VersionRange("{1.3,1.4.2)");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingDelimiter() {
        VersionRange range = new VersionRange("1.3,1.4.2)");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidVersion() {
        VersionRange range = new VersionRange("[1.3,0,1.4.2)");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidCreateVersionRanges() {
        List ranges = VersionRange.createVersionRanges((String)"(,1.4.2),1.5.0_11,1.6),[1.7,]");
        for (VersionRange vr : ranges) {
            System.out.println(vr);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidDelimiterCreateVersionRanges() {
        List ranges = VersionRange.createVersionRanges((String)"(,1.4.2)|[1.5.0_11,1.6)|[1.7,]");
        for (VersionRange vr : ranges) {
            System.out.println(vr);
        }
    }
}

