/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.builders.SimpleConfigurationBuilder;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.interception.ProcessorInterceptorManager;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class QueueManagerLifecycleOrderTestCase
extends AbstractMuleTestCase {
    private List<Object> startStopOrder = new ArrayList<Object>();
    private RecordingTQM rtqm = new RecordingTQM();
    @Rule
    public TestServicesConfigurationBuilder testServicesConfigurationBuilder = new TestServicesConfigurationBuilder();
    private MuleContext muleContext;

    @Before
    public void before() throws InitialisationException, ConfigurationException {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_muleQueueManager", this.rtqm);
        objects.put("_muleSecurityManager", new DefaultMuleSecurityManager());
        objects.put("_muleProcessorInterceptorManager", Mockito.mock(ProcessorInterceptorManager.class));
        this.muleContext = new DefaultMuleContextFactory().createMuleContext(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, new SimpleConfigurationBuilder(objects)});
        this.testServicesConfigurationBuilder.configure(this.muleContext);
    }

    @After
    public void after() {
        this.muleContext.dispose();
    }

    @Test
    public void testStartupOrder() throws Exception {
        ((MuleContextWithRegistries)this.muleContext).getRegistry().registerObject("_muleNotificationDispatcher", Mockito.mock(NotificationDispatcher.class));
        RecordingFlow fc = new RecordingFlow("dummy", this.muleContext);
        ((MuleContextWithRegistries)this.muleContext).getRegistry().registerFlowConstruct((FlowConstruct)fc);
        this.muleContext.start();
        this.muleContext.stop();
        Assert.assertEquals((long)4L, (long)this.startStopOrder.size());
        Assert.assertSame((Object)this.rtqm, (Object)this.startStopOrder.get(0));
        Assert.assertSame((Object)((Object)fc), (Object)this.startStopOrder.get(1));
        Assert.assertSame((Object)((Object)fc), (Object)this.startStopOrder.get(2));
        Assert.assertSame((Object)this.rtqm, (Object)this.startStopOrder.get(3));
    }

    private class RecordingFlow
    extends DefaultFlowBuilder.DefaultFlow {
        public RecordingFlow(String name, MuleContext muleContext) {
            super(name, muleContext, null, Collections.emptyList(), Optional.empty(), Optional.empty(), "started", AsyncProcessingStrategyFactory.DEFAULT_MAX_CONCURRENCY, null, new ComponentInitialStateManager(){

                public boolean mustStartMessageSource(Component component) {
                    return true;
                }
            });
        }

        public void doStart() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }

        public void doStop() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }
    }

    private class RecordingTQM
    implements QueueManager {
        private RecordingTQM() {
        }

        public void start() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }

        public void stop() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }

        public QueueSession getQueueSession() {
            throw this.notImplementedException();
        }

        public void setDefaultQueueConfiguration(QueueConfiguration config) {
            throw this.notImplementedException();
        }

        public void setQueueConfiguration(String queueName, QueueConfiguration config) {
            throw this.notImplementedException();
        }

        public Optional<QueueConfiguration> getQueueConfiguration(String queueName) {
            throw this.notImplementedException();
        }

        private NotImplementedException notImplementedException() {
            return new NotImplementedException("This is test code");
        }
    }
}

