/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import io.qameta.allure.Issue;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.store.PartitionableObjectStore;
import org.mule.runtime.api.store.SimpleMemoryObjectStore;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.store.PartitionedInMemoryObjectStore;
import org.mule.runtime.core.internal.store.PartitionedPersistentObjectStore;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.runtime.core.internal.util.store.ObjectStorePartition;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class ManagedStoresTestCase
extends AbstractMuleContextTestCase {
    protected void doSetUp() throws Exception {
        super.doSetUp();
        MuleObjectStoreManager manager = (MuleObjectStoreManager)this.getRegistry().lookupObject("_muleObjectStoreManager");
        manager.clearStoreCache();
    }

    @Test
    public void testInMemoryStore() throws ObjectStoreException, InterruptedException, RegistrationException {
        this.getRegistry().registerObject("_defaultInMemoryObjectStore", (Object)new SimpleMemoryObjectStore());
        ObjectStoreManager manager = (ObjectStoreManager)this.getRegistry().lookupObject("_muleObjectStoreManager");
        ObjectStore store = manager.createObjectStore("inMemoryPart1", ObjectStoreSettings.unmanagedTransient());
        this.testObjectStore((ObjectStore<String>)store);
        this.testObjectStoreExpiry(manager, "inMemoryExpPart1", ObjectStoreSettings.builder().persistent(false).entryTtl(Long.valueOf(500L)).expirationInterval(Long.valueOf(200L)).build());
        this.testObjectStoreMaxEntries(manager, "inMemoryMaxPart1", ObjectStoreSettings.builder().persistent(false).maxEntries(Integer.valueOf(10)).entryTtl(Long.valueOf(10000L)).expirationInterval(Long.valueOf(200L)).build());
    }

    @Test
    public void testClearPartition() throws ObjectStoreException, InterruptedException, RegistrationException {
        this.getRegistry().registerObject("_defaultInMemoryObjectStore", (Object)new SimpleMemoryObjectStore());
        ObjectStoreManager manager = (ObjectStoreManager)this.getRegistry().lookupObject("_muleObjectStoreManager");
        ObjectStore partition1 = manager.createObjectStore("inMemoryPart1", ObjectStoreSettings.unmanagedTransient());
        ObjectStore partition2 = manager.createObjectStore("inMemoryPart2", ObjectStoreSettings.unmanagedTransient());
        partition1.store("key1", (Serializable)((Object)"value1"));
        partition2.store("key2", (Serializable)((Object)"value2"));
        Assert.assertEquals((Object)"value1", (Object)partition1.retrieve("key1"));
        Assert.assertEquals((Object)"value2", (Object)partition2.retrieve("key2"));
        partition1.clear();
        Assert.assertEquals((Object)"value2", (Object)partition2.retrieve("key2"));
    }

    @Test
    public void testPartitionableInMemoryStore() throws ObjectStoreException, RegistrationException, InterruptedException {
        this.getRegistry().registerObject("_defaultInMemoryObjectStore", (Object)new PartitionedInMemoryObjectStore());
        ObjectStoreManager manager = (ObjectStoreManager)this.getRegistry().lookupObject("_muleObjectStoreManager");
        ObjectStore store = manager.createObjectStore("inMemoryPart2", ObjectStoreSettings.unmanagedTransient());
        Assert.assertTrue((boolean)(store instanceof ObjectStorePartition));
        PartitionableObjectStore baseStore = ((ObjectStorePartition)store).getBaseStore();
        Assert.assertTrue((boolean)(baseStore instanceof PartitionedInMemoryObjectStore));
        this.testObjectStore((ObjectStore<String>)store);
        this.testObjectStoreExpiry(manager, "inMemoryExpPart2", ObjectStoreSettings.builder().persistent(false).entryTtl(Long.valueOf(500L)).expirationInterval(Long.valueOf(200L)).build());
        this.testObjectStoreMaxEntries(manager, "inMemoryMaxPart2", ObjectStoreSettings.builder().persistent(false).maxEntries(Integer.valueOf(10)).entryTtl(Long.valueOf(10000L)).expirationInterval(Long.valueOf(200L)).build());
    }

    @Ignore(value="MULE-6926")
    @Issue(value="MULE-6926")
    @Test
    public void testPartitionablePersistenceStore() throws ObjectStoreException, RegistrationException, InterruptedException {
        PartitionedPersistentObjectStore partitionedStore = new PartitionedPersistentObjectStore(muleContext);
        partitionedStore.open();
        this.getRegistry().registerObject("_defaultPersistentObjectStore", (Object)partitionedStore);
        ObjectStoreManager manager = (ObjectStoreManager)this.getRegistry().lookupObject("_muleObjectStoreManager");
        ObjectStore store = manager.createObjectStore("persistencePart2", ObjectStoreSettings.unmanagedPersistent());
        Assert.assertTrue((boolean)(store instanceof ObjectStorePartition));
        PartitionableObjectStore baseStore = ((ObjectStorePartition)store).getBaseStore();
        Assert.assertTrue((boolean)(baseStore instanceof PartitionedPersistentObjectStore));
        Assert.assertSame((Object)baseStore, (Object)this.getRegistry().lookupObject("_defaultPersistentObjectStore"));
        this.testObjectStore((ObjectStore<String>)store);
        this.testObjectStoreExpiry(manager, "persistenceExpPart2", ObjectStoreSettings.builder().persistent(true).entryTtl(Long.valueOf(1000L)).expirationInterval(Long.valueOf(200L)).build());
        this.testObjectStoreMaxEntries(manager, "persistenceMaxPart2", ObjectStoreSettings.builder().persistent(true).maxEntries(Integer.valueOf(10)).entryTtl(Long.valueOf(10000L)).expirationInterval(Long.valueOf(200L)).build());
    }

    private MuleRegistry getRegistry() {
        return ((MuleContextWithRegistries)muleContext).getRegistry();
    }

    private void testObjectStore(ObjectStore<String> store) throws ObjectStoreException {
        Throwable e = null;
        store.store("key1", (Serializable)((Object)"value1"));
        Assert.assertEquals((Object)"value1", (Object)store.retrieve("key1"));
        Assert.assertTrue((boolean)store.contains("key1"));
        store.clear();
        Assert.assertFalse((boolean)store.contains("key1"));
        store.store("key1", (Serializable)((Object)"value1"));
        try {
            store.store("key1", (Serializable)((Object)"value1"));
        }
        catch (ObjectAlreadyExistsException e1) {
            e = e1;
        }
        Assert.assertNotNull((Object)e);
        e = null;
        Assert.assertEquals((long)1L, (long)store.allKeys().size());
        Assert.assertEquals((Object)"key1", store.allKeys().get(0));
        Assert.assertEquals((Object)"value1", (Object)store.remove("key1"));
        Assert.assertFalse((boolean)store.contains("key1"));
        try {
            store.retrieve("key1");
        }
        catch (ObjectDoesNotExistException e1) {
            e = e1;
        }
        Assert.assertNotNull((Object)e);
        e = null;
        try {
            store.remove("key1");
        }
        catch (ObjectDoesNotExistException e1) {
            e = e1;
        }
        Assert.assertNotNull((Object)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testObjectStoreExpiry(ObjectStoreManager manager, String storeName, ObjectStoreSettings settings) throws ObjectStoreException, InterruptedException {
        ObjectStore objectStore = manager.createObjectStore(storeName, settings);
        try {
            objectStore.store("key1", (Serializable)((Object)"value1"));
            Assert.assertEquals((Object)"value1", (Object)objectStore.retrieve("key1"));
            new PollingProber(2000L, 50L).check((Probe)new JUnitLambdaProbe(() -> {
                try {
                    Assert.assertFalse((String)"Object with key1 still exists.", (boolean)objectStore.contains("key1"));
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                return true;
            }));
        }
        finally {
            manager.disposeStore(storeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testObjectStoreMaxEntries(ObjectStoreManager manager, String storeName, ObjectStoreSettings settings) throws ObjectStoreException, InterruptedException {
        ObjectStore objectStore = manager.createObjectStore(storeName, settings);
        try {
            this.storeObjects((ObjectStore<String>)objectStore, 0, 90);
            this.ensureMillisecondChanged();
            this.storeObjects((ObjectStore<String>)objectStore, 90, 100);
            new PollingProber(2000L, 50L).check((Probe)new JUnitLambdaProbe(() -> {
                try {
                    Assert.assertEquals((long)10L, (long)objectStore.allKeys().size());
                    for (int i = 90; i < 100; ++i) {
                        Assert.assertTrue((String)("Checking that key" + i + " exists"), (boolean)objectStore.contains("key" + i));
                    }
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                return true;
            }));
        }
        finally {
            manager.disposeStore(storeName);
        }
    }

    private void ensureMillisecondChanged() throws InterruptedException {
        Thread.sleep(2L);
    }

    private void storeObjects(ObjectStore<String> objectStore, int start, int stop) throws ObjectStoreException {
        for (int i = start; i < stop; ++i) {
            objectStore.store("key" + i, (Serializable)((Object)("value" + i)));
            Assert.assertEquals((Object)("value" + i), (Object)objectStore.retrieve("key" + i));
        }
    }
}

