/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.internal.util.store.AbstractMonitoredObjectStore;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MonitoredObjectStoreTestCase
extends AbstractMuleContextTestCase {
    private static final int EXPIRATION_INTERVAL = 500;

    @Test
    public void testShutdownWithHangingExpireThread() throws Exception {
        ExpiringStore store = this.createExpiringStore();
        Thread.sleep(1000L);
        store.dispose();
        Assert.assertTrue((boolean)store.expireStarted);
        Assert.assertFalse((boolean)store.expireFinished);
    }

    private ExpiringStore createExpiringStore() throws InitialisationException {
        ExpiringStore store = new ExpiringStore();
        store.setMuleContext(muleContext);
        store.setExpirationInterval(500);
        store.initialise();
        return store;
    }

    private static class ExpiringStore
    extends AbstractMonitoredObjectStore<String> {
        boolean expireStarted = false;
        boolean expireFinished = false;

        protected void expire() {
            try {
                this.expireStarted = true;
                Thread.sleep(5000L);
                this.expireFinished = true;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("expire was interrupted", e);
            }
        }

        protected boolean doContains(String key) throws ObjectStoreException {
            return false;
        }

        protected String doRemove(String key) throws ObjectStoreException {
            return null;
        }

        protected String doRetrieve(String key) throws ObjectStoreException {
            return null;
        }

        protected void doStore(String key, String value) throws ObjectStoreException {
        }

        public void clear() {
        }

        public boolean isPersistent() {
            return false;
        }

        public void open() throws ObjectStoreException {
        }

        public void close() throws ObjectStoreException {
        }

        public List<String> allKeys() throws ObjectStoreException {
            return null;
        }

        public Map<String, String> retrieveAll() throws ObjectStoreException {
            return null;
        }
    }
}

