/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class MuleObjectStoreDisposalTestCase
extends AbstractMuleContextTestCase {
    private static final String TEST_OS_NAME = "disposalTest";
    private static final int MAX_ENTRIES = 100;
    private static final long TIMEOUT = 9999L;
    private static final String DISPOSABLE_TRANSIENT_USER_STORE_KEY = "DISPOSABLE_TRANSIENT_USER_STORE_KEY";
    private MuleObjectStoreManager osm;
    @Mock(extraInterfaces={Disposable.class})
    private ObjectStore disposableStore;

    protected void doSetUp() throws Exception {
        this.osm = (MuleObjectStoreManager)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject("_muleObjectStoreManager");
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject(DISPOSABLE_TRANSIENT_USER_STORE_KEY, (Object)this.disposableStore);
        this.osm.setBaseTransientStoreKey(DISPOSABLE_TRANSIENT_USER_STORE_KEY);
    }

    @Test
    public void disposeMonitoredObjectStores() throws Exception {
        ObjectStore managedObjectStore = this.osm.createObjectStore(TEST_OS_NAME, ObjectStoreSettings.builder().persistent(false).maxEntries(Integer.valueOf(100)).entryTtl(Long.valueOf(9999L)).expirationInterval(Long.valueOf(9999L)).build());
        junit.framework.Assert.assertNotNull((Object)managedObjectStore);
        Assert.assertTrue((boolean)(managedObjectStore instanceof Disposable));
        this.doDispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.disposableStore))).dispose();
    }

    private void doDispose() {
        muleContext.dispose();
        muleContext = null;
    }
}

