/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreNotAvailableException;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@RunWith(value=Parameterized.class)
public class MuleObjectStoreManagerIntegrationTestCase
extends AbstractMuleContextTestCase {
    private static final String OBJECT_KEY = "key";
    private static final String OBJECT_KEY_VALUE_1 = "value";
    private static final String OBJECT_KEY_VALUE_2 = "anotherValue";
    private final ObjectStoreFactory objectStoreFactory;

    public MuleObjectStoreManagerIntegrationTestCase(ObjectStoreFactory objectStoreFactory) {
        this.objectStoreFactory = objectStoreFactory;
    }

    @Parameterized.Parameters
    public static Collection<Object> parameters() {
        return Arrays.asList(new ObjectStoreFactory(false), new ObjectStoreFactory(true));
    }

    @Before
    public void injectMuleContext() {
        this.objectStoreFactory.setMuleObjectStoreManager((MuleObjectStoreManager)((MuleContextWithRegistries)muleContext).getRegistry().get("_muleObjectStoreManager"));
    }

    @Test
    public void partitionObjectStoreDoesNotCollide() throws Exception {
        Object os = this.objectStoreFactory.createObjectStore("myOs");
        Object os2 = this.objectStoreFactory.createObjectStore("myOs2");
        os.store(OBJECT_KEY, (Serializable)((Object)OBJECT_KEY_VALUE_1));
        os2.store(OBJECT_KEY, (Serializable)((Object)OBJECT_KEY_VALUE_2));
        Assert.assertThat((Object)os.contains(OBJECT_KEY), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)os.retrieve(OBJECT_KEY), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_1));
        Assert.assertThat((Object)os2.contains(OBJECT_KEY), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)os2.retrieve(OBJECT_KEY), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_2));
        Assert.assertThat((Object)os.remove(OBJECT_KEY), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_1));
        Assert.assertThat((Object)os2.remove(OBJECT_KEY), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_2));
    }

    @Test
    public void maxEntriesIsHonored() throws Exception {
        int expirationInterval = 1000;
        int maxEntries = 5;
        Object os = this.objectStoreFactory.createObjectStore("myOs", 5, 0L, 1000L);
        os.store("0", (Serializable)Integer.valueOf(0));
        this.ensureMilisecondChanged();
        for (int i = 1; i < 6; ++i) {
            os.store(String.valueOf(i), (Serializable)Integer.valueOf(i));
        }
        PollingProber prober = new PollingProber(5000L, 1000L);
        prober.check((Probe)new JUnitProbe((ObjectStore)os){
            final /* synthetic */ ObjectStore val$os;
            {
                this.val$os = objectStore;
            }

            public boolean test() throws Exception {
                Assert.assertThat((Object)this.val$os.contains("0"), (Matcher)Is.is((Object)false));
                for (int i = 1; i < 6; ++i) {
                    Assert.assertThat((Object)this.val$os.contains(String.valueOf(i)), (Matcher)Is.is((Object)true));
                }
                return true;
            }

            public String describeFailure() {
                return "max entries were not honoured";
            }
        });
    }

    @Test
    public void expirationIntervalWithLowTTL() throws Exception {
        int maxEntries = 5;
        int entryTTL = 10;
        int expirationInterval = 100;
        Object os = this.objectStoreFactory.createObjectStore("myOs", maxEntries, entryTTL, expirationInterval);
        for (int i = 0; i < maxEntries; ++i) {
            os.store(String.valueOf(i), (Serializable)Integer.valueOf(i));
        }
        PollingProber prober = new PollingProber(1000L, (long)expirationInterval);
        prober.check((Probe)new JUnitProbe((ObjectStore)os){
            final /* synthetic */ ObjectStore val$os;
            {
                this.val$os = objectStore;
            }

            public boolean test() throws Exception {
                return this.val$os.allKeys().isEmpty();
            }

            public String describeFailure() {
                return "not all entries were evicted";
            }
        });
    }

    @Test
    public void expirationIntervalWithHighTTLPersistentObjectStore() throws Exception {
        int i;
        int maxEntries = 5;
        int entryTTL = 10000;
        Object os = this.objectStoreFactory.createObjectStore("myOs", maxEntries, entryTTL, 100L);
        os.store("0", (Serializable)Integer.valueOf(0));
        this.ensureMilisecondChanged();
        for (i = 1; i < maxEntries; ++i) {
            os.store(String.valueOf(i), (Serializable)Integer.valueOf(i));
        }
        os.store(OBJECT_KEY, (Serializable)((Object)OBJECT_KEY_VALUE_1));
        Thread.sleep(entryTTL / 5);
        Assert.assertThat((Object)os.allKeys().size(), (Matcher)Is.is((Object)maxEntries));
        for (i = 1; i < maxEntries; ++i) {
            Assert.assertThat((Object)os.contains(String.valueOf(i)), (Matcher)Is.is((Object)true));
        }
        Assert.assertThat((Object)os.contains(OBJECT_KEY), (Matcher)Is.is((Object)true));
    }

    private void ensureMilisecondChanged() throws InterruptedException {
        Thread.sleep(2L);
    }

    @Test
    public void onlySizeBoundedObjectStore() throws Exception {
        int maxEntries = 5;
        boolean entryTTL = false;
        Object os = this.objectStoreFactory.createObjectStore("myOs", 5, 0L, 1000L);
        os.store("0", (Serializable)Integer.valueOf(0));
        this.ensureMilisecondChanged();
        for (int i = 1; i < 6; ++i) {
            os.store(String.valueOf(i), (Serializable)Integer.valueOf(i));
        }
        PollingProber prober = new PollingProber(5000L, 1000L);
        prober.check((Probe)new JUnitProbe((ObjectStore)os){
            final /* synthetic */ ObjectStore val$os;
            {
                this.val$os = objectStore;
            }

            public boolean test() throws Exception {
                Assert.assertThat((Object)this.val$os.allKeys().size(), (Matcher)Is.is((Object)5));
                for (int i = 1; i < 6; ++i) {
                    Assert.assertThat((Object)this.val$os.contains(String.valueOf(i)), (Matcher)Is.is((Object)true));
                }
                return true;
            }

            public String describeFailure() {
                return "objectStore was not trimmed";
            }
        });
    }

    @Test
    public void storeUsingBigKey() throws Exception {
        Object os = this.objectStoreFactory.createObjectStore("myOs");
        StringBuilder bigKey = new StringBuilder();
        for (int i = 0; i < 50; ++i) {
            bigKey.append("abcdefghijklmnopqrstuvwxyz");
        }
        os.store(bigKey.toString(), (Serializable)Integer.valueOf(1));
        Assert.assertThat((Object)os.retrieve(bigKey.toString()), (Matcher)Is.is((Object)1));
    }

    private static class ObjectStoreFactory {
        private final boolean isPersistent;
        private MuleObjectStoreManager muleObjectStoreManager;

        public ObjectStoreFactory(boolean isPersistent) {
            this.isPersistent = isPersistent;
        }

        public void setMuleObjectStoreManager(MuleObjectStoreManager muleObjectStoreManager) {
            this.muleObjectStoreManager = muleObjectStoreManager;
        }

        public <T extends ObjectStore<? extends Serializable>> T createObjectStore(String name) throws ObjectStoreNotAvailableException {
            return (T)this.muleObjectStoreManager.createObjectStore(name, ObjectStoreSettings.builder().persistent(this.isPersistent).build());
        }

        public <T extends ObjectStore<? extends Serializable>> T createObjectStore(String name, int maxEntries, long entryTTL, long expirationInterval) throws ObjectStoreNotAvailableException {
            return (T)this.muleObjectStoreManager.createObjectStore(name, ObjectStoreSettings.builder().persistent(this.isPersistent).maxEntries(Integer.valueOf(maxEntries)).entryTtl(Long.valueOf(entryTTL)).expirationInterval(Long.valueOf(expirationInterval)).build());
        }
    }
}

