/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.store.PartitionableObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.store.PartitionedInMemoryObjectStore;
import org.mule.runtime.core.internal.store.PartitionedPersistentObjectStore;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.runtime.core.internal.util.store.ObjectStorePartition;
import org.mule.tck.SerializationTestUtils;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MuleObjectStoreManagerTestCase
extends AbstractMuleTestCase {
    private static final String TEST_PARTITION_NAME = "partition";
    private static final int POLLING_TIMEOUT = 1000;
    private static final int POLLING_DELAY = 60;
    private static final String TEST_KEY = "Some Key";
    private static final String TEST_VALUE = "Some Value";
    private SimpleUnitTestSupportSchedulerService schedulerService;
    private MuleContextWithRegistries muleContext;
    private MuleObjectStoreManager storeManager;
    private volatile CountDownLatch expireDelayLatch = new CountDownLatch(0);
    private AtomicInteger expires = new AtomicInteger();
    @Rule
    public TemporaryFolder tempWorkDir = new TemporaryFolder();

    @Before
    public void setup() {
        this.schedulerService = new SimpleUnitTestSupportSchedulerService();
        this.muleContext = (MuleContextWithRegistries)Mockito.mock(MuleContextWithRegistries.class);
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.getWorkingDirectory()).thenReturn((Object)this.tempWorkDir.getRoot().getAbsolutePath());
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        Registry registry = (Registry)Mockito.mock(Registry.class);
        this.createRegistryAndBaseStore(this.muleContext, registry);
        Mockito.when((Object)this.muleContext.getSchedulerBaseConfig()).thenReturn((Object)SchedulerConfig.config().withPrefix(MuleObjectStoreManagerTestCase.class.getName() + "#" + this.name.getMethodName()));
        this.storeManager = new MuleObjectStoreManager();
        this.storeManager.setSchedulerService((SchedulerService)this.schedulerService);
        this.storeManager.setRegistry(registry);
        this.storeManager.setMuleContext((MuleContext)this.muleContext);
    }

    @After
    public void after() throws MuleException {
        this.schedulerService.stop();
    }

    @Test
    public void ensureTransientPartitionIsCleared() throws ObjectStoreException, InitialisationException {
        this.ensurePartitionIsCleared(false);
    }

    @Test
    public void ensurePersistentPartitionIsCleared() throws ObjectStoreException, InitialisationException {
        this.ensurePartitionIsCleared(true);
    }

    @Test
    public void expireTwoStoresInParallel() throws ObjectStoreException, InitialisationException, InterruptedException {
        Mockito.when((Object)this.muleContext.isPrimaryPollingInstance()).thenReturn((Object)true);
        this.expireDelayLatch = new CountDownLatch(1);
        SerializationTestUtils.addJavaSerializerToMockMuleContext((MuleContext)this.muleContext);
        this.storeManager.initialise();
        this.storeManager.createObjectStore("partition_1", ObjectStoreSettings.builder().persistent(false).entryTtl(Long.valueOf(10L)).expirationInterval(Long.valueOf(10L)).build());
        this.storeManager.createObjectStore("partition_2", ObjectStoreSettings.builder().persistent(false).entryTtl(Long.valueOf(10L)).expirationInterval(Long.valueOf(10L)).build());
        new PollingProber(1000L, 60L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)this.expires.get(), (Matcher)Is.is((Object)2));
            return true;
        }));
        this.expireDelayLatch.countDown();
    }

    private void ensurePartitionIsCleared(boolean isPersistent) throws ObjectStoreException, InitialisationException {
        try {
            ObjectStorePartition<Serializable> store = this.createStorePartition(TEST_PARTITION_NAME, isPersistent);
            store.getBaseStore().store(TEST_KEY, (Serializable)((Object)TEST_VALUE), TEST_PARTITION_NAME);
            Assert.assertThat((Object)store.allKeys().size(), (Matcher)Is.is((Object)1));
            this.storeManager.disposeStore(TEST_PARTITION_NAME);
            Assert.assertThat((Object)store.allKeys().size(), (Matcher)Is.is((Object)0));
        }
        finally {
            this.storeManager.dispose();
        }
    }

    @Test
    public void removeStoreAndMonitorOnTransientPartition() throws ObjectStoreException, InitialisationException {
        this.removeStoreAndMonitor(false);
    }

    @Test
    public void removeStoreAndMonitorOnPersistentPartition() throws ObjectStoreException, InitialisationException {
        this.removeStoreAndMonitor(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStoreAndMonitor(boolean isPersistent) throws ObjectStoreException, InitialisationException {
        try {
            ObjectStorePartition<Serializable> store = this.createStorePartition(TEST_PARTITION_NAME, isPersistent);
            this.assertMonitorsCount(1);
            this.storeManager.disposeStore(TEST_PARTITION_NAME);
            try {
                this.storeManager.getObjectStore(TEST_PARTITION_NAME);
                Assert.fail((String)"ObjectStore should not exist");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.assertMonitorsCount(0);
        }
        finally {
            this.storeManager.dispose();
        }
    }

    private void assertMonitorsCount(final int expectedValue) {
        new PollingProber(1000L, 60L).check(new Probe(){

            public boolean isSatisfied() {
                return this.assertMonitors(expectedValue);
            }

            private boolean assertMonitors(int expectedValue2) {
                return MuleObjectStoreManagerTestCase.this.storeManager.getMonitorsCount() == expectedValue2;
            }

            public String describeFailure() {
                return "Unexpected count of active monitors.";
            }
        });
    }

    private ObjectStorePartition<Serializable> createStorePartition(String partitionName, boolean isPersistent) throws InitialisationException {
        SerializationTestUtils.addJavaSerializerToMockMuleContext((MuleContext)this.muleContext);
        this.storeManager.initialise();
        ObjectStorePartition store = (ObjectStorePartition)this.storeManager.createObjectStore(partitionName, ObjectStoreSettings.builder().persistent(isPersistent).entryTtl(Long.valueOf(10000L)).expirationInterval(Long.valueOf(50L)).build());
        Assert.assertThat((Object)this.storeManager.getObjectStore(partitionName), (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)store)));
        return store;
    }

    private void createRegistryAndBaseStore(MuleContextWithRegistries muleContext, Registry registry) {
        Mockito.when((Object)registry.lookupByName("_defaultPersistentObjectStore")).thenReturn(Optional.of(this.createPersistentPartitionableObjectStore((MuleContext)muleContext)));
        Mockito.when((Object)registry.lookupByName("_defaultInMemoryObjectStore")).thenReturn(Optional.of(this.createTransientPartitionableObjectStore()));
    }

    private PartitionableObjectStore<?> createTransientPartitionableObjectStore() {
        return new PartitionedInMemoryObjectStore(){

            public void expire(long entryTTL, int maxEntries, String partitionName) throws ObjectStoreException {
                MuleObjectStoreManagerTestCase.this.expires.incrementAndGet();
                super.expire(entryTTL, maxEntries, partitionName);
                MuleObjectStoreManagerTestCase.this.expireDelay();
            }
        };
    }

    private PartitionableObjectStore<?> createPersistentPartitionableObjectStore(MuleContext muleContext) {
        return new PartitionedPersistentObjectStore(muleContext){

            public void expire(long entryTTL, int maxEntries, String partitionName) throws ObjectStoreException {
                MuleObjectStoreManagerTestCase.this.expires.incrementAndGet();
                super.expire(entryTTL, maxEntries, partitionName);
                MuleObjectStoreManagerTestCase.this.expireDelay();
            }
        };
    }

    private void expireDelay() {
        try {
            this.expireDelayLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

