/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.internal.store.PartitionedInMemoryObjectStore;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class PartitionedInMemoryObjectStoreTestCase
extends AbstractMuleTestCase {
    private static final String TEST_PARTITION = "testPartition";
    private static final String TEST_VALUE = "testValue";
    private static final String TEST_KEY1 = "testKey1";
    private static final String TEST_KEY2 = "testKey2";
    private static final String TEST_KEY3 = "testKey3";
    private PartitionedInMemoryObjectStore<String> store;
    private long currentNanoTime = TimeUnit.MILLISECONDS.toNanos(1L);

    @Before
    public void setup() {
        this.store = new PartitionedInMemoryObjectStore(){

            protected long getCurrentNanoTime() {
                return PartitionedInMemoryObjectStoreTestCase.this.currentNanoTime;
            }
        };
    }

    @Test
    public void expireByTtlMultipleKeysInsertedInTheSameNanoSecond() throws ObjectStoreException {
        this.store.store(TEST_KEY1, (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.store(TEST_KEY2, (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.currentNanoTime = TimeUnit.MILLISECONDS.toNanos(2L);
        this.store.store(TEST_KEY3, (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.expire(1L, 100, TEST_PARTITION);
        Assert.assertThat((Object)this.store.contains(TEST_KEY1, TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.store.contains(TEST_KEY2, TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.store.retrieve(TEST_KEY3, TEST_PARTITION), (Matcher)CoreMatchers.equalTo((Object)TEST_VALUE));
    }

    @Test
    public void expireByNumberOfEntriesMultipleKeysInsertedInTheSameNanoSecond() throws ObjectStoreException {
        this.store.store(TEST_KEY1, (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.store(TEST_KEY2, (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.currentNanoTime = TimeUnit.MILLISECONDS.toNanos(2L);
        this.store.store(TEST_KEY3, (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.expire(10L, 1, TEST_PARTITION);
        Assert.assertThat((Object)this.store.contains(TEST_KEY1, TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.store.contains(TEST_KEY2, TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.store.retrieve(TEST_KEY3, TEST_PARTITION), (Matcher)CoreMatchers.equalTo((Object)TEST_VALUE));
    }

    @Test
    public void removeKeyInsertedInTheSameNanosecondThanOther() throws ObjectStoreException {
        this.store.store(TEST_KEY1, (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.store(TEST_KEY2, (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.currentNanoTime = TimeUnit.MILLISECONDS.toNanos(2L);
        this.store.store(TEST_KEY3, (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.remove(TEST_KEY2, TEST_PARTITION);
        Assert.assertThat((Object)this.store.retrieve(TEST_KEY1, TEST_PARTITION), (Matcher)CoreMatchers.equalTo((Object)TEST_VALUE));
        Assert.assertThat((Object)this.store.contains(TEST_KEY2, TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.store.retrieve(TEST_KEY3, TEST_PARTITION), (Matcher)CoreMatchers.equalTo((Object)TEST_VALUE));
    }
}

