/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.OptionalLong;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.tck.testmodels.fruit.Apple;

public class TypedValueTestCase {
    private static String STRING_VALUE = "MY_VALUE";
    private static byte[] BYTE_ARRAY_VALUE = "MY_VALUE".getBytes();
    private static InputStream INPUT_STREAM_VALUE = new ByteArrayInputStream(BYTE_ARRAY_VALUE);

    @Test
    public void string() {
        TypedValue typedValue = TypedValue.of((Object)STRING_VALUE);
        Assert.assertThat((Object)typedValue.getByteLength().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)typedValue.getByteLength().getAsLong(), (Matcher)CoreMatchers.is((Object)STRING_VALUE.length()));
    }

    @Test
    public void stringUTF16() {
        TypedValue typedValue = new TypedValue((Object)STRING_VALUE, DataType.builder((DataType)DataType.STRING).charset(StandardCharsets.UTF_16).build());
        Assert.assertThat((Object)typedValue.getByteLength().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)typedValue.getByteLength().getAsLong(), (Matcher)CoreMatchers.is((Object)STRING_VALUE.getBytes(StandardCharsets.UTF_16).length));
    }

    @Test
    public void byteArray() {
        TypedValue typedValue = TypedValue.of((Object)BYTE_ARRAY_VALUE);
        Assert.assertThat((Object)typedValue.getByteLength().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)typedValue.getByteLength().getAsLong(), (Matcher)CoreMatchers.is((Object)BYTE_ARRAY_VALUE.length));
    }

    @Test
    public void inputStream() {
        Assert.assertThat((Object)TypedValue.of((Object)INPUT_STREAM_VALUE).getByteLength().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void inputStreamWithLength() {
        TypedValue typedValue = new TypedValue((Object)INPUT_STREAM_VALUE, DataType.OBJECT, OptionalLong.of(BYTE_ARRAY_VALUE.length));
        Assert.assertThat((Object)typedValue.getByteLength().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)typedValue.getByteLength().getAsLong(), (Matcher)CoreMatchers.is((Object)BYTE_ARRAY_VALUE.length));
    }

    @Test
    public void object() {
        Assert.assertThat((Object)TypedValue.of((Object)new Apple()).getByteLength().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }
}

