/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.component;

import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.privileged.component.AbstractExecutableComponent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ExecutableComponentTestCase
extends AbstractMuleContextTestCase {
    private TestExecutableComponent executableComponent = new TestExecutableComponent();
    private Message requestMessage;
    private Message responseMessage = Message.of((Object)"Response");
    private AtomicReference<CoreEvent> componentInEvent = new AtomicReference();

    protected void doSetUp() throws Exception {
        muleContext.getInjector().inject((Object)this.executableComponent);
        this.requestMessage = this.testEvent().getMessage();
    }

    @Test
    public void testExecuteWithInputEvent() throws Exception {
        ExecutionResult executionResult = (ExecutionResult)this.executableComponent.execute(InputEvent.create().message(this.requestMessage)).get();
        Event response = executionResult.getEvent();
        Assert.assertThat((Object)this.componentInEvent.get().getMessage(), (Matcher)CoreMatchers.equalTo((Object)this.requestMessage));
        Assert.assertThat((Object)response.getMessage(), (Matcher)CoreMatchers.equalTo((Object)this.responseMessage));
        Assert.assertThat((Object)this.componentInEvent.get().getContext(), (Matcher)CoreMatchers.equalTo((Object)response.getContext()));
        BaseEventContext eventContext = (BaseEventContext)this.componentInEvent.get().getContext();
        Assert.assertThat((Object)eventContext.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        executionResult.complete();
        Assert.assertThat((Object)eventContext.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testExecuteWithEvent() throws Exception {
        Event response = (Event)this.executableComponent.execute((Event)this.testEvent()).get();
        Assert.assertThat((Object)this.componentInEvent.get().getMessage(), (Matcher)CoreMatchers.equalTo((Object)this.requestMessage));
        Assert.assertThat((Object)response.getMessage(), (Matcher)CoreMatchers.equalTo((Object)this.responseMessage));
        Assert.assertThat((Object)this.componentInEvent.get().getContext(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)response.getContext())));
        Assert.assertThat((Object)((BaseEventContext)this.componentInEvent.get().getContext()).isTerminated(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((BaseEventContext)response.getContext()).isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        BaseEventContext childContext = (BaseEventContext)this.componentInEvent.get().getContext();
        Assert.assertThat((Object)childContext.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
        BaseEventContext parentContext = (BaseEventContext)this.testEvent().getContext();
        Assert.assertThat((Object)parentContext.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        ((BaseEventContext)this.testEvent().getContext()).success();
        Assert.assertThat((Object)parentContext.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
    }

    final class TestExecutableComponent
    extends AbstractExecutableComponent
    implements ReactiveProcessor {
        TestExecutableComponent() {
        }

        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Mono.from(publisher).map(event -> {
                ExecutableComponentTestCase.this.componentInEvent.set(event);
                return CoreEvent.builder((CoreEvent)event).message(ExecutableComponentTestCase.this.responseMessage).build();
            });
        }
    }
}

