/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.exception.AbstractErrorTypeMatcherTestCase;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;

@Feature(value="Error Handling")
@Story(value="Error Types")
public class SingleErrorTypeMatcherTestCase
extends AbstractErrorTypeMatcherTestCase {
    @Test
    public void anyMatchsAll() {
        ErrorType mockErrorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)mockErrorType.getParentErrorType()).thenReturn((Object)this.transformationErrorType);
        SingleErrorTypeMatcher anyMatcher = new SingleErrorTypeMatcher(this.anyErrorType);
        Assert.assertThat((Object)anyMatcher.match(this.anyErrorType), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)anyMatcher.match(this.transformationErrorType), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)anyMatcher.match(this.expressionErrorType), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)anyMatcher.match(mockErrorType), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void matchEqual() {
        SingleErrorTypeMatcher transformationMatcher = new SingleErrorTypeMatcher(this.transformationErrorType);
        Assert.assertThat((Object)transformationMatcher.match(this.transformationErrorType), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void matchChild() {
        ComponentIdentifier customTransformerIdentifier = ComponentIdentifier.builder().name("custom").namespace(Errors.CORE_NAMESPACE_NAME).build();
        ErrorTypeRepository errorTypeRepository = muleContext.getErrorTypeRepository();
        ErrorType customTransformerErrorType = errorTypeRepository.addErrorType(customTransformerIdentifier, this.transformationErrorType);
        SingleErrorTypeMatcher transformationMatcher = new SingleErrorTypeMatcher(this.transformationErrorType);
        Assert.assertThat((Object)transformationMatcher.match(customTransformerErrorType), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void doesNotMatchParent() {
        SingleErrorTypeMatcher transformationMatcher = new SingleErrorTypeMatcher(this.transformationErrorType);
        Assert.assertThat((Object)transformationMatcher.match(this.anyErrorType), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void doesNotMatchSibling() {
        SingleErrorTypeMatcher transformationMatcher = new SingleErrorTypeMatcher(this.transformationErrorType);
        Assert.assertThat((Object)transformationMatcher.match(this.expressionErrorType), (Matcher)Matchers.is((Object)false));
    }
}

