/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.execution;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.privileged.execution.LocationExecutionContextProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class LocationExecutionContextProviderTestCase
extends AbstractMuleTestCase {
    @Mock
    private Component component;

    @Test
    public void sanitizedUrl() {
        this.withXmlElement(this.component, "<sftp:outbound-endpoint url=\"sftp://muletest:muletest@localhost:22198/~/testdir");
        String sanitized = LocationExecutionContextProvider.getSourceXML((Component)this.component);
        Assert.assertThat((Object)sanitized, (Matcher)CoreMatchers.equalTo((Object)"<sftp:outbound-endpoint url=\"sftp://<<credentials>>@localhost:22198/~/testdir"));
    }

    @Test
    public void sanitizedAddress() {
        this.withXmlElement(this.component, "<sftp:outbound-endpoint address=\"sftp://muletest:muletest@localhost:22198/~/testdir");
        String sanitized = LocationExecutionContextProvider.getSourceXML((Component)this.component);
        Assert.assertThat((Object)sanitized, (Matcher)CoreMatchers.equalTo((Object)"<sftp:outbound-endpoint address=\"sftp://<<credentials>>@localhost:22198/~/testdir"));
    }

    @Test
    public void sanitizedPasswordAttribute() {
        this.withXmlElement(this.component, "<sftp:config username=\"user\" password=\"pass\" />");
        String sanitized = LocationExecutionContextProvider.getSourceXML((Component)this.component);
        Assert.assertThat((Object)sanitized, (Matcher)CoreMatchers.equalTo((Object)"<sftp:config username=\"user\" password=\"<<credentials>>\" />"));
    }

    private void withXmlElement(Component component, String value) {
        Mockito.when((Object)component.getAnnotation(LocationExecutionContextProvider.SOURCE_ELEMENT_ANNOTATION_KEY)).thenReturn((Object)value);
    }
}

