/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.interception.ProcessorInterceptorManager;
import org.mule.runtime.core.internal.processor.AsyncDelegateMessageProcessor;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.CompositeProcessorChainRouter;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@Feature(value="Routers")
@Story(value="Processor Chain Router")
public class CompositeProcessorChainRouterTestCase
extends AbstractMuleContextTestCase {
    private CompositeProcessorChainRouter chainRouter;
    private AsyncDelegateMessageProcessor async;
    private Scheduler scheduler;

    @Before
    public void setup() throws MuleException {
        this.scheduler = muleContext.getSchedulerService().ioScheduler();
        MuleTestUtils.createAndRegisterFlow((MuleContext)muleContext, (String)"appleFlow", (ConfigurationComponentLocator)this.componentLocator);
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_muleConfigurationComponentLocator", this.componentLocator);
        objects.put("_muleProcessorInterceptorManager", Mockito.mock(ProcessorInterceptorManager.class));
        return objects;
    }

    @After
    public void tearDown() throws MuleException {
        this.chainRouter.stop();
        this.chainRouter.dispose();
        if (this.async != null) {
            this.async.stop();
            this.async.dispose();
        }
        this.scheduler.stop();
    }

    @Test
    @Description(value="Ensure that with simple chains both chains are executed consecutively with the result of the first chain being used for the second chain.")
    public void simpleChain() throws Exception {
        Message chain1Out = Message.of((Object)1);
        Message chain2Out = Message.of((Object)2);
        AtomicReference chain1In = new AtomicReference();
        AtomicReference chain2In = new AtomicReference();
        MessageProcessorChain chain1 = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> {
            chain1In.set(event.getMessage());
            return CoreEvent.builder((CoreEvent)event).message(chain1Out).build();
        }});
        MessageProcessorChain chain2 = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> {
            chain2In.set(event.getMessage());
            return CoreEvent.builder((CoreEvent)event).message(chain2Out).build();
        }});
        this.chainRouter = this.createCompositeProcessorChainRouter(chain1, chain2);
        Message result = ((Event)this.chainRouter.execute((Event)this.testEvent()).get()).getMessage();
        Assert.assertThat(chain1In.get(), (Matcher)CoreMatchers.equalTo((Object)this.testEvent().getMessage()));
        Assert.assertThat(chain2In.get(), (Matcher)CoreMatchers.equalTo((Object)chain1Out));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)chain2Out));
    }

    @Test
    @Description(value="Ensure that when a child context is created as part of the execution of one of the composite chains then the chain does not complete and the next chains is not executed until the child context completes.")
    public void childContextChain() throws Exception {
        Latch latch = new Latch();
        AtomicReference childEventContext = new AtomicReference();
        MessageProcessorChain chainUsingChildContext = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> {
            latch.release();
            childEventContext.set(DefaultEventContext.child((BaseEventContext)((BaseEventContext)event.getContext()), Optional.empty()));
            return event;
        }});
        this.chainRouter = this.createCompositeProcessorChainRouter(chainUsingChildContext, MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> event}));
        Future future = this.scheduler.submit(() -> this.chainRouter.execute((Event)this.testEvent()));
        latch.await();
        try {
            future.get(500L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Timeout expected");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        ((BaseEventContext)childEventContext.get()).success();
        Assert.assertThat((Object)((Event)((CompletableFuture)future.get(500L, TimeUnit.MILLISECONDS)).get()).getMessage(), (Matcher)CoreMatchers.equalTo((Object)this.testEvent().getMessage()));
    }

    @Test
    @Description(value="Ensure that when an async scope is used as part of the execution of one of the composite chains then the chain does not complete and the next chains is not executed until the child context completes.")
    public void asyncDelegateChain() throws Exception {
        Latch latch = new Latch();
        Latch asyncLatch = new Latch();
        this.async = new AsyncDelegateMessageProcessor(MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> {
            try {
                asyncLatch.countDown();
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return event;
        }}));
        muleContext.getInjector().inject((Object)this.async);
        this.async.setAnnotations(CompositeProcessorChainRouterTestCase.getAppleFlowComponentLocationAnnotations());
        this.chainRouter = this.createCompositeProcessorChainRouter(MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{this.async}), MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> event}));
        this.chainRouter.start();
        Future future = this.scheduler.submit(() -> this.chainRouter.execute((Event)this.testEvent()));
        asyncLatch.await();
        try {
            future.get(500L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Timeout expected");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        latch.countDown();
        Assert.assertThat((Object)((Event)((CompletableFuture)future.get(500L, TimeUnit.MILLISECONDS)).get()).getMessage(), (Matcher)CoreMatchers.equalTo((Object)this.testEvent().getMessage()));
    }

    private CompositeProcessorChainRouter createCompositeProcessorChainRouter(MessageProcessorChain chain1, MessageProcessorChain chain2) throws InitialisationException {
        CompositeProcessorChainRouter chainRouter = new CompositeProcessorChainRouter();
        chainRouter.setProcessorChains(Arrays.asList(chain1, chain2));
        chainRouter.setMuleContext(muleContext);
        chainRouter.initialise();
        return chainRouter;
    }
}

