/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.store.TemplateObjectStore;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.lock.LockProvider;
import org.mule.runtime.core.internal.lock.MuleLockFactory;
import org.mule.runtime.core.internal.lock.SingleServerLockProvider;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.processor.IdempotentRedeliveryPolicy;
import org.mule.tck.SerializationTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.util.MuleContextUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class IdempotentRedeliveryPolicyTestCase
extends AbstractMuleTestCase {
    public static final String STRING_MESSAGE = "message";
    public static final int MAX_REDELIVERY_COUNT = 5;
    private static ObjectSerializer serializer;
    private MuleContextWithRegistries mockMuleContext = MuleContextUtils.mockMuleContext();
    private ObjectStoreManager mockObjectStoreManager = (ObjectStoreManager)Mockito.mock(ObjectStoreManager.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private Processor mockFailingMessageProcessor = (Processor)Mockito.mock(Processor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private Processor mockWaitingMessageProcessor = (Processor)Mockito.mock(Processor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private CoreEvent event;
    private Latch waitLatch = new Latch();
    private CountDownLatch waitingMessageProcessorExecutionLatch = new CountDownLatch(2);
    private ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
    private final IdempotentRedeliveryPolicy irp = new IdempotentRedeliveryPolicy();
    private AtomicInteger count = new AtomicInteger();
    private ObjectStore mockObjectStore = (ObjectStore)Mockito.mock(ObjectStore.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUpTest() throws MuleException {
        this.event = (CoreEvent)Mockito.spy((Object)this.testEvent());
        Mockito.when((Object)this.mockFailingMessageProcessor.apply((Publisher)Matchers.any(Publisher.class))).thenAnswer(invocation -> {
            MessagingException me = (MessagingException)Mockito.mock(MessagingException.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
            CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class);
            Mockito.when((Object)event.getError()).thenReturn(Optional.of(Mockito.mock(Error.class)));
            Mockito.when((Object)me.getEvent()).thenReturn((Object)event);
            return Mono.error((Throwable)me).doOnError(e -> this.count.getAndIncrement());
        });
        Mockito.when((Object)this.mockWaitingMessageProcessor.apply((Publisher)Matchers.any(Publisher.class))).thenAnswer(invocationOnMock -> {
            Mono mono = Mono.from((Publisher)((Publisher)invocationOnMock.getArgumentAt(0, Publisher.class)));
            return mono.doOnNext(Exceptions.checkedConsumer(event1 -> {
                this.waitingMessageProcessorExecutionLatch.countDown();
                this.waitLatch.await(2000L, TimeUnit.MILLISECONDS);
            })).transform((Function)this.mockFailingMessageProcessor);
        });
        MuleLockFactory muleLockFactory = new MuleLockFactory();
        muleLockFactory.setLockProvider((LockProvider)new SingleServerLockProvider());
        muleLockFactory.initialise();
        Mockito.when((Object)this.mockMuleContext.getConfiguration().getDefaultEncoding()).thenReturn((Object)StandardCharsets.UTF_8.name());
        InMemoryObjectStore inMemoryObjectStore = new InMemoryObjectStore();
        Mockito.when((Object)this.mockObjectStoreManager.getObjectStore(Matchers.anyString())).thenReturn((Object)inMemoryObjectStore);
        Mockito.when((Object)this.mockObjectStoreManager.createObjectStore((String)Matchers.any(), (ObjectStoreSettings)Matchers.any())).thenReturn((Object)inMemoryObjectStore);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        serializer = SerializationTestUtils.getJavaSerializerWithMockContext();
        this.irp.setExpressionManager(this.expressionManager);
        this.irp.setMaxRedeliveryCount(5);
        this.irp.setUseSecureHash(true);
        this.irp.setMuleContext((MuleContext)this.mockMuleContext);
        this.irp.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        this.irp.setListener(this.mockFailingMessageProcessor);
        this.irp.setLockFactory((LockFactory)muleLockFactory);
        this.irp.setObjectStoreManager(this.mockObjectStoreManager);
    }

    @Test
    public void messageDigestFailure() throws Exception {
        Mockito.when((Object)this.expressionManager.evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(BindingContext.class), (CoreEvent)Matchers.any(CoreEvent.class))).thenThrow(new Class[]{ExpressionRuntimeException.class});
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue(new Object(), DataType.OBJECT));
        this.irp.initialise();
        CoreEvent process = this.irp.process(this.event);
        Assert.assertThat((Object)process, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testMessageRedeliveryUsingMemory() throws Exception {
        Mockito.when((Object)this.expressionManager.evaluate((String)Matchers.eq((Object)String.format(IdempotentRedeliveryPolicy.SECURE_HASH_EXPR_FORMAT, "SHA-256")), (DataType)Matchers.eq((Object)DataType.STRING), (BindingContext)Matchers.eq((Object)BindingContextUtils.NULL_BINDING_CONTEXT), (CoreEvent)Matchers.any())).thenAnswer(inv -> new TypedValue((Object)("" + ((CoreEvent)inv.getArgumentAt(3, CoreEvent.class)).getMessage().getPayload().hashCode()), DataType.STRING));
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue((Object)STRING_MESSAGE, DataType.STRING));
        this.irp.initialise();
        this.processUntilFailure();
        Assert.assertThat((Object)this.count.get(), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void testMessageRedeliveryUsingSerializationStore() throws Exception {
        Mockito.when((Object)this.expressionManager.evaluate((String)Matchers.eq((Object)String.format(IdempotentRedeliveryPolicy.SECURE_HASH_EXPR_FORMAT, "SHA-256")), (DataType)Matchers.eq((Object)DataType.STRING), (BindingContext)Matchers.eq((Object)BindingContextUtils.NULL_BINDING_CONTEXT), (CoreEvent)Matchers.any())).thenAnswer(inv -> new TypedValue((Object)("" + ((CoreEvent)inv.getArgumentAt(3, CoreEvent.class)).getMessage().getPayload().hashCode()), DataType.STRING));
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue((Object)STRING_MESSAGE, DataType.STRING));
        Mockito.reset((Object[])new ObjectStoreManager[]{this.mockObjectStoreManager});
        SerializationObjectStore serializationObjectStore = new SerializationObjectStore();
        Mockito.when((Object)this.mockObjectStoreManager.createObjectStore((String)Matchers.any(), (ObjectStoreSettings)Matchers.any())).thenReturn((Object)serializationObjectStore);
        this.irp.initialise();
        this.processUntilFailure();
        Assert.assertThat((Object)this.count.get(), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void testThreadSafeObjectStoreUsage() throws Exception {
        Mockito.when((Object)this.expressionManager.evaluate((String)Matchers.eq((Object)String.format(IdempotentRedeliveryPolicy.SECURE_HASH_EXPR_FORMAT, "SHA-256")), (DataType)Matchers.eq((Object)DataType.STRING), (BindingContext)Matchers.eq((Object)BindingContextUtils.NULL_BINDING_CONTEXT), (CoreEvent)Matchers.any())).thenAnswer(inv -> new TypedValue((Object)("" + ((CoreEvent)inv.getArgumentAt(3, CoreEvent.class)).getMessage().getPayload().hashCode()), DataType.STRING));
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue((Object)STRING_MESSAGE, DataType.STRING));
        this.irp.setListener(this.mockWaitingMessageProcessor);
        this.irp.initialise();
        ExecuteIrpThread firstIrpExecutionThread = new ExecuteIrpThread();
        firstIrpExecutionThread.start();
        ExecuteIrpThread threadCausingRedeliveryException = new ExecuteIrpThread();
        threadCausingRedeliveryException.start();
        this.waitingMessageProcessorExecutionLatch.await(5000L, TimeUnit.MILLISECONDS);
        this.waitLatch.release();
        firstIrpExecutionThread.join();
        threadCausingRedeliveryException.join();
        Assert.assertThat((Object)this.count.get(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void multipleObjectStoreConfigurationShouldRaiseException() throws Exception {
        this.irp.setObjectStore(this.mockObjectStore);
        this.irp.setPrivateObjectStore(this.mockObjectStore);
        this.expectedException.expect(InitialisationException.class);
        this.irp.initialise();
    }

    private void processUntilFailure() {
        for (int i = 0; i < 7; ++i) {
            try {
                this.irp.process(this.event);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class InMemoryObjectStore
    extends TemplateObjectStore<IdempotentRedeliveryPolicy.RedeliveryCounter> {
        private Map<String, IdempotentRedeliveryPolicy.RedeliveryCounter> store = new HashMap<String, IdempotentRedeliveryPolicy.RedeliveryCounter>();

        protected boolean doContains(String key) throws ObjectStoreException {
            return this.store.containsKey(key);
        }

        protected void doStore(String key, IdempotentRedeliveryPolicy.RedeliveryCounter value) throws ObjectStoreException {
            this.store.put(key, value);
        }

        protected IdempotentRedeliveryPolicy.RedeliveryCounter doRetrieve(String key) throws ObjectStoreException {
            return this.store.get(key);
        }

        protected IdempotentRedeliveryPolicy.RedeliveryCounter doRemove(String key) throws ObjectStoreException {
            return this.store.remove(key);
        }

        public void clear() throws ObjectStoreException {
            this.store.clear();
        }

        public boolean isPersistent() {
            return false;
        }

        public void open() throws ObjectStoreException {
        }

        public void close() throws ObjectStoreException {
        }

        public List<String> allKeys() throws ObjectStoreException {
            return new ArrayList<String>(this.store.keySet());
        }

        public Map<String, IdempotentRedeliveryPolicy.RedeliveryCounter> retrieveAll() throws ObjectStoreException {
            return Collections.unmodifiableMap(this.store);
        }
    }

    public static class SerializationObjectStore
    extends TemplateObjectStore<IdempotentRedeliveryPolicy.RedeliveryCounter> {
        private Map<String, Serializable> store = new HashMap<String, Serializable>();

        protected boolean doContains(String key) throws ObjectStoreException {
            return this.store.containsKey(key);
        }

        protected void doStore(String key, IdempotentRedeliveryPolicy.RedeliveryCounter value) throws ObjectStoreException {
            this.store.put(key, (Serializable)serializer.getExternalProtocol().serialize((Object)value));
        }

        protected IdempotentRedeliveryPolicy.RedeliveryCounter doRetrieve(String key) throws ObjectStoreException {
            Serializable serializable = this.store.get(key);
            return (IdempotentRedeliveryPolicy.RedeliveryCounter)serializer.getExternalProtocol().deserialize((byte[])serializable);
        }

        protected IdempotentRedeliveryPolicy.RedeliveryCounter doRemove(String key) throws ObjectStoreException {
            Serializable serializable = this.store.remove(key);
            return (IdempotentRedeliveryPolicy.RedeliveryCounter)serializer.getExternalProtocol().deserialize((byte[])serializable);
        }

        public boolean isPersistent() {
            return false;
        }

        public void clear() throws ObjectStoreException {
            this.store.clear();
        }

        public void open() throws ObjectStoreException {
        }

        public void close() throws ObjectStoreException {
        }

        public List<String> allKeys() throws ObjectStoreException {
            return new ArrayList<String>(this.store.keySet());
        }

        public Map<String, IdempotentRedeliveryPolicy.RedeliveryCounter> retrieveAll() throws ObjectStoreException {
            return this.store.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (IdempotentRedeliveryPolicy.RedeliveryCounter)serializer.getExternalProtocol().deserialize((byte[])entry.getValue())));
        }
    }

    public class ExecuteIrpThread
    extends Thread {
        public Exception exception;

        @Override
        public void run() {
            try {
                IdempotentRedeliveryPolicyTestCase.this.irp.process(IdempotentRedeliveryPolicyTestCase.this.event);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

