/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.MessageProcessorNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.util.ObjectUtils;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.ResponseMessageProcessorAdapter;
import org.mule.runtime.core.internal.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ProactorStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ReactorProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.TransactionAwareWorkQueueProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.WorkQueueProcessingStrategyFactory;
import org.mule.runtime.core.internal.routing.ChoiceRouter;
import org.mule.runtime.core.internal.routing.ScatterGatherRouter;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.core.privileged.processor.InternalProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessorBuilder;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.size.SmallTest;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@RunWith(value=Parameterized.class)
@SmallTest
public class DefaultMessageProcessorChainTestCase
extends AbstractReactiveProcessorTestCase {
    protected MuleContext muleContext;
    private AtomicInteger nonBlockingProcessorsExecuted = new AtomicInteger(0);
    private ProcessingStrategyFactory processingStrategyFactory;
    private final RuntimeException illegalStateException = new IllegalStateException();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Flow flow;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({new TransactionAwareWorkQueueProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new ReactorProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new ProactorStreamProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new WorkQueueProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new BlockingProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new DirectProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new TransactionAwareWorkQueueProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING}, {new ReactorProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING}, {new ProactorStreamProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING}, {new WorkQueueProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING}, {new BlockingProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING}, {new DirectProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING});
    }

    public DefaultMessageProcessorChainTestCase(ProcessingStrategyFactory processingStrategyFactory, AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
        this.processingStrategyFactory = processingStrategyFactory;
    }

    @Before
    public void before() throws MuleException {
        this.nonBlockingProcessorsExecuted.set(0);
        this.muleContext = (MuleContext)Mockito.spy((Object)AbstractReactiveProcessorTestCase.muleContext);
        ErrorTypeLocator errorTypeLocator = (ErrorTypeLocator)Mockito.mock(ErrorTypeLocator.class);
        ErrorType errorType = (ErrorType)Mockito.mock(ErrorType.class);
        ExceptionContextProvider exceptionContextProvider = (ExceptionContextProvider)Mockito.mock(ExceptionContextProvider.class);
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.isContainerMode()).thenReturn((Object)false);
        Mockito.when((Object)muleConfiguration.getId()).thenReturn((Object)RandomStringUtils.randomNumeric((int)3));
        Mockito.when((Object)muleConfiguration.getShutdownTimeout()).thenReturn((Object)1000L);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        Mockito.when((Object)((PrivilegedMuleContext)this.muleContext).getErrorTypeLocator()).thenReturn((Object)errorTypeLocator);
        Mockito.when((Object)this.muleContext.getExceptionContextProviders()).thenReturn(Collections.singletonList(exceptionContextProvider));
        Mockito.when((Object)errorTypeLocator.lookupErrorType((Throwable)((Exception)Matchers.any()))).thenReturn((Object)errorType);
        this.flow = Flow.builder((String)"flow", (MuleContext)this.muleContext).processingStrategyFactory(this.processingStrategyFactory).build();
        this.flow.initialise();
        this.flow.start();
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap("_muleConfigurationComponentLocator", this.componentLocator);
    }

    @After
    public void after() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.muleContext.getSchedulerService());
        this.flow.stop();
        this.flow.dispose();
    }

    @Test
    public void testMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3")});
        Assert.assertEquals((Object)"0123", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMPChainWithNullReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingMP mp1 = this.getAppendingMP("1");
        AppendingMP mp2 = this.getAppendingMP("2");
        ReturnNullMP nullmp = new ReturnNullMP();
        AppendingMP mp3 = this.getAppendingMP("3");
        builder.chain(new Processor[]{mp1, mp2, nullmp, mp3});
        CoreEvent requestEvent = this.getTestEventUsingFlow("0");
        Assert.assertNull((Object)this.process((Processor)builder.build(), requestEvent));
        Assert.assertSame((Object)requestEvent.getMessage(), (Object)mp1.event.getMessage());
        Assert.assertNotSame((Object)mp1.event, (Object)mp1.resultEvent);
        Assert.assertEquals((Object)"01", (Object)mp1.resultEvent.getMessage().getPayload().getValue());
        Assert.assertSame((Object)mp1.resultEvent.getMessage(), (Object)mp2.event.getMessage());
        Assert.assertNotSame((Object)mp2.event, (Object)mp2.resultEvent);
        Assert.assertEquals((Object)"012", (Object)mp2.resultEvent.getMessage().getPayload().getValue());
        Assert.assertSame((Object)mp2.resultEvent.getMessage(), (Object)nullmp.event.getMessage());
        Assert.assertEquals((Object)"012", (Object)nullmp.event.getMessage().getPayload().getValue());
        Assert.assertNull((Object)mp3.event);
    }

    @Test
    public void testMPChainWithVoidReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingMP mp1 = this.getAppendingMP("1");
        AppendingMP mp2 = this.getAppendingMP("2");
        ReturnVoidMP voidmp = new ReturnVoidMP();
        AppendingMP mp3 = this.getAppendingMP("3");
        builder.chain(new Processor[]{mp1, mp2, voidmp, mp3});
        CoreEvent requestEvent = this.getTestEventUsingFlow("0");
        Assert.assertEquals((Object)"0123", (Object)this.process((Processor)builder.build(), requestEvent).getMessage().getPayload().getValue());
        Assert.assertNotSame((Object)mp1.event, (Object)mp1.resultEvent);
        Assert.assertNotSame((Object)mp2.event, (Object)mp2.resultEvent);
        Assert.assertEquals((Object)mp2.resultEvent.getMessage(), (Object)voidmp.event.getMessage());
        Assert.assertThat((Object)mp3.event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)mp2.resultEvent.getMessage().getPayload().getValue()));
        Assert.assertEquals((Object)mp3.event.getMessage().getPayload().getValue(), (Object)"012");
    }

    @Test
    public void testMPChainWithNullReturnAtEnd() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnNullMP()});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMPChainWithVoidReturnAtEnd() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnVoidMP()});
        Assert.assertEquals((Object)"0123", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMPChainWithBuilder() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1")});
        builder.chain(new MessageProcessorBuilder[]{() -> this.getAppendingMP("2")});
        builder.chain(new Processor[]{this.getAppendingMP("3")});
        Assert.assertEquals((Object)"0123", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testInterceptingMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1before2before3after3after2after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testInterceptingMPChainWithNullReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP lastMP = new AppendingInterceptingMP("3");
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new ReturnNullInterceptongMP(), lastMP});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertFalse((boolean)lastMP.invoked);
    }

    @Test
    public void testInterceptingMPChainWithVoidReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP lastMP = new AppendingInterceptingMP("3");
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new ReturnNullInterceptongMP(), lastMP});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertFalse((boolean)lastMP.invoked);
    }

    @Test
    public void testMixedMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMixedMPChainWithNullReturn1() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new ReturnNullInterceptongMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidReturn1() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new ReturnVoidMPInterceptongMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"0before1after1"));
    }

    @Test
    public void testMixedMPChainWithNullReturn2() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnNullInterceptongMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidlReturn2() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnVoidMPInterceptongMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before12after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMixedMPChainWithNullReturn3() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new ReturnNullMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidReturn3() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new ReturnVoidMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMixedMPChainWithNullReturn4() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnNullMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidReturn4() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnVoidMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMixedMPChainWithNullReturn5() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnNullMP(), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidReturn5() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnVoidMP(), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMixedMPChainWithNullReturnAtEnd() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5"), new ReturnNullMP()});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidReturnAtEnd() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5"), new ReturnVoidMP()});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), this.getAppendingMP("b")}).build(), this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedMPChainWithNullReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), new ReturnNullMP(), this.getAppendingMP("b")}).build(), new ReturnNullMP(), this.getAppendingMP("2")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testNestedMPChainWithVoidReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), new ReturnVoidMP(), this.getAppendingMP("b")}).build(), new ReturnVoidMP(), this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedMPChainWithNullReturnAtEndOfNestedChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnNullMP()}).build(), this.getAppendingMP("2")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testNestedMPChainWithVoidReturnAtEndOfNestedChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnVoidMP()}).build(), this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedMPChainWithNullReturnAtEndOfNestedChainWithNonInterceptingWrapper() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        MessageProcessorChain nested = new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnNullMP()}).build();
        nested.setMuleContext(this.muleContext);
        builder.chain(new Processor[]{this.getAppendingMP("1"), event -> nested.process(event), this.getAppendingMP("2")});
        Assert.assertNull((String)"012", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testNestedMPChainWithVoidReturnAtEndOfNestedChainWithNonInterceptingWrapper() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        MessageProcessorChain nested = new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnVoidMP()}).build();
        nested.setMuleContext(this.muleContext);
        builder.chain(new Processor[]{this.getAppendingMP("1"), event -> nested.process((CoreEvent)InternalEvent.builder((CoreEvent)event).message(event.getMessage()).build()), this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedInterceptingMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{new AppendingInterceptingMP("a"), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertEquals((Object)"0before1beforeabeforebafterbafterabefore2after2after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedInterceptingMPChainWithNullReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{new AppendingInterceptingMP("a"), new ReturnNullInterceptongMP(), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testNestedInterceptingMPChainWithVoidReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{new AppendingInterceptingMP("a"), new ReturnVoidMPInterceptongMP(), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"0before1beforeaafterabefore2after2after1"));
    }

    @Test
    public void testNestedMixedMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{new AppendingInterceptingMP("a"), this.getAppendingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertEquals((Object)"01beforeabafterabefore2after2", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testInterceptingMPChainStopFlow() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2", true), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedInterceptingMPChainStopFlow() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{new AppendingInterceptingMP("a", true), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1before3after3after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMPChainLifecycle() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP mp1 = new AppendingInterceptingMP("1");
        AppendingInterceptingMP mp2 = new AppendingInterceptingMP("2");
        MessageProcessorChain chain = builder.chain(new Processor[]{mp1, mp2}).build();
        LifecycleUtils.initialiseIfNeeded((Object)chain, (MuleContext)this.muleContext);
        ((Lifecycle)chain).start();
        ((Lifecycle)chain).stop();
        ((Lifecycle)chain).dispose();
        this.assertLifecycle(mp1);
        this.assertLifecycle(mp2);
    }

    @Test
    public void testNestedMPChainLifecycle() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        DefaultMessageProcessorChainBuilder nestedBuilder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP mp1 = new AppendingInterceptingMP("1");
        AppendingInterceptingMP mp2 = new AppendingInterceptingMP("2");
        AppendingInterceptingMP mpa = new AppendingInterceptingMP("a");
        AppendingInterceptingMP mpb = new AppendingInterceptingMP("b");
        MessageProcessorChain chain = builder.chain(new Processor[]{mp1, nestedBuilder.chain(new Processor[]{mpa, mpb}).build(), mp2}).build();
        LifecycleUtils.initialiseIfNeeded((Object)chain, (MuleContext)this.muleContext);
        ((Lifecycle)chain).start();
        ((Lifecycle)chain).stop();
        ((Lifecycle)chain).dispose();
        this.assertLifecycle(mp1);
        this.assertLifecycle(mp2);
        this.assertLifecycle(mpa);
        this.assertLifecycle(mpb);
    }

    @Test
    public void testNoneIntercepting() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        CoreEvent restul = this.process((Processor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessage().getPayload().getValue());
    }

    @Test
    public void testAllIntercepting() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new TestIntercepting(), new TestIntercepting(), new TestIntercepting()});
        CoreEvent restul = this.process((Processor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorInterceptingMessageProcessorInterceptingMessageProcessor", (Object)restul.getMessage().getPayload().getValue());
    }

    @Test
    public void testMix() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        CoreEvent restul = this.process((Processor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessage().getPayload().getValue());
    }

    @Test
    public void testMixStaticFactoryt() throws Exception {
        MessageProcessorChain chain = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        CoreEvent restul = this.process((Processor)chain, this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessage().getPayload().getValue());
    }

    @Test
    public void testMix2() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting()});
        CoreEvent restul = this.process((Processor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessor", (Object)restul.getMessage().getPayload().getValue());
    }

    @Test
    public void testMix2StaticFactory() throws Exception {
        MessageProcessorChain chain = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting()});
        CoreEvent result = this.process((Processor)chain, this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessor", (Object)result.getMessage().getPayload().getValue());
    }

    @Test
    public void testResponseProcessor() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)this.getAppendingMP("3"));
        responseMessageProcessorAdapter.setMuleContext(this.muleContext);
        builder.chain(new Processor[]{this.getAppendingMP("1"), responseMessageProcessorAdapter, this.getAppendingMP("2")});
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"0123"));
    }

    @Test
    public void testResponseProcessorInNestedChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)this.getAppendingMP("c"));
        responseMessageProcessorAdapter.setMuleContext(this.muleContext);
        builder.chain(new Processor[]{this.getAppendingMP("1"), MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{this.getAppendingMP("a"), responseMessageProcessorAdapter, this.getAppendingMP("b")}), this.getAppendingMP("2")});
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"01abc2"));
    }

    @Test
    public void testNestedResponseProcessor() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        ResponseMessageProcessorAdapter innerResponseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)this.getAppendingMP("4"));
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{innerResponseMessageProcessorAdapter, this.getAppendingMP("3")}));
        builder.chain(new Processor[]{this.getAppendingMP("1"), responseMessageProcessorAdapter, this.getAppendingMP("2")});
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"01234"));
    }

    @Test
    public void testNestedResponseProcessorEndOfChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        MessageProcessorChain chain = MessageProcessors.newChain(Optional.empty(), Collections.singletonList(this.getAppendingMP("1")));
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)chain);
        responseMessageProcessorAdapter.setMuleContext(this.muleContext);
        builder.chain(new Processor[]{responseMessageProcessorAdapter});
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"01"));
    }

    @Test
    public void testAll() throws Exception {
        MuleTestUtils.createAndRegisterFlow((MuleContext)this.muleContext, (String)"appleFlow", (ConfigurationComponentLocator)this.componentLocator);
        ScatterGatherRouter scatterGatherRouter = new ScatterGatherRouter();
        scatterGatherRouter.setAnnotations(DefaultMessageProcessorChainTestCase.getAppleFlowComponentLocationAnnotations());
        scatterGatherRouter.setRoutes(Arrays.asList(MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{this.getAppendingMP("1")}), MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{this.getAppendingMP("2")}), MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{this.getAppendingMP("3")})));
        LifecycleUtils.initialiseIfNeeded((Object)scatterGatherRouter, (boolean)true, (MuleContext)this.muleContext);
        scatterGatherRouter.start();
        CoreEvent event = this.getTestEventUsingFlow("0");
        MessageProcessorChain chain = MessageProcessors.newChain(Optional.empty(), Collections.singletonList(scatterGatherRouter));
        Message result = this.process((Processor)chain, CoreEvent.builder((CoreEvent)event).message(event.getMessage()).build()).getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Map.class));
        Map resultMessage = (Map)result.getPayload().getValue();
        Assert.assertThat((Object)resultMessage.values().stream().map(msg -> msg.getPayload().getValue()).collect(Collectors.toList()).toArray(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)new String[]{"01", "02", "03"})));
        scatterGatherRouter.stop();
        scatterGatherRouter.dispose();
    }

    @Test
    public void testChoice() throws Exception {
        ChoiceRouter choiceRouter = new ChoiceRouter();
        choiceRouter.setAnnotations(DefaultMessageProcessorChainTestCase.getAppleFlowComponentLocationAnnotations());
        choiceRouter.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        choiceRouter.addRoute("true", (Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{this.getAppendingMP("1")}));
        choiceRouter.addRoute("true", (Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{this.getAppendingMP("2")}));
        choiceRouter.addRoute("true", (Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{this.getAppendingMP("3")}));
        LifecycleUtils.initialiseIfNeeded((Object)choiceRouter, (MuleContext)this.muleContext);
        Assert.assertThat((Object)this.process((Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{choiceRouter}), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"01"));
    }

    @Test
    public void testExceptionAfter() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new ExceptionThrowingMessageProcessor(this.illegalStateException)});
        this.expectedException.expect(Is.is((Object)this.illegalStateException));
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    @Test
    public void testExceptionBefore() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new ExceptionThrowingMessageProcessor(this.illegalStateException), this.getAppendingMP("1")});
        this.expectedException.expect(Is.is((Object)this.illegalStateException));
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    @Test
    public void testExceptionBetween() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new ExceptionThrowingMessageProcessor(this.illegalStateException), this.getAppendingMP("2")});
        this.expectedException.expect(Is.is((Object)this.illegalStateException));
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    @Test
    public void testExceptionInResponse() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new ResponseMessageProcessorAdapter((Processor)new ExceptionThrowingMessageProcessor(this.illegalStateException)), this.getAppendingMP("1")});
        this.expectedException.expect(Is.is((Object)this.illegalStateException));
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    @Test
    public void testSuccessNotifications() throws Exception {
        ArrayList<MessageProcessorNotification> notificationList = new ArrayList<MessageProcessorNotification>();
        this.setupMessageProcessorNotificationListener(notificationList);
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1")});
        CoreEvent inEvent = this.getTestEventUsingFlow("0");
        String resultPayload = "01";
        Assert.assertThat((Object)this.process((Processor)builder.build(), inEvent).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"01"));
        Assert.assertThat(notificationList, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MessageProcessorNotification preNotification = (MessageProcessorNotification)notificationList.get(0);
        MessageProcessorNotification postNotification = (MessageProcessorNotification)notificationList.get(1);
        this.assertPreNotification(inEvent, preNotification);
        Assert.assertThat((Object)postNotification.getAction().getActionId(), (Matcher)CoreMatchers.equalTo((Object)1602));
        Assert.assertThat((Object)postNotification.getEventContext(), (Matcher)CoreMatchers.equalTo((Object)inEvent.getContext()));
        Assert.assertThat((Object)postNotification.getEvent(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)inEvent)));
        Assert.assertThat((Object)postNotification.getEvent().getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"01"));
        Assert.assertThat((Object)postNotification.getException(), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testErrorNotifications() throws Exception {
        ArrayList<MessageProcessorNotification> notificationList = new ArrayList<MessageProcessorNotification>();
        this.setupMessageProcessorNotificationListener(notificationList);
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new ExceptionThrowingMessageProcessor(this.illegalStateException)});
        CoreEvent inEvent = this.getTestEventUsingFlow("0");
        try {
            this.process((Processor)builder.build(), inEvent);
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)Is.is((Object)this.illegalStateException));
            Assert.assertThat(notificationList, (Matcher)IsCollectionWithSize.hasSize((int)2));
            MessageProcessorNotification preNotification = (MessageProcessorNotification)notificationList.get(0);
            MessageProcessorNotification postNotification = (MessageProcessorNotification)notificationList.get(1);
            this.assertPreNotification(inEvent, preNotification);
            Assert.assertThat((Object)postNotification.getAction().getActionId(), (Matcher)CoreMatchers.equalTo((Object)1602));
            Assert.assertThat((Object)postNotification.getEventContext(), (Matcher)CoreMatchers.equalTo((Object)inEvent.getContext()));
            this.assertPostErrorNotification(inEvent, postNotification);
        }
    }

    @Test
    public void testErrorNotificationsMessagingException() throws Exception {
        ArrayList<MessageProcessorNotification> notificationList = new ArrayList<MessageProcessorNotification>();
        this.setupMessageProcessorNotificationListener(notificationList);
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        CoreEvent messagingExceptionEvent = this.getTestEventUsingFlow("other");
        MessagingException messagingException = new MessagingException(messagingExceptionEvent, (Throwable)this.illegalStateException);
        builder.chain(new Processor[]{new ExceptionThrowingMessageProcessor((Exception)messagingException)});
        CoreEvent inEvent = this.getTestEventUsingFlow("0");
        try {
            this.process((Processor)builder.build(), inEvent);
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
            Assert.assertThat(notificationList, (Matcher)IsCollectionWithSize.hasSize((int)2));
            MessageProcessorNotification preNotification = (MessageProcessorNotification)notificationList.get(0);
            MessageProcessorNotification postNotification = (MessageProcessorNotification)notificationList.get(1);
            this.assertPreNotification(inEvent, preNotification);
            Assert.assertThat((Object)postNotification.getAction().getActionId(), (Matcher)CoreMatchers.equalTo((Object)1602));
            Assert.assertThat((Object)postNotification.getEvent(), (Matcher)CoreMatchers.not((Object)messagingExceptionEvent));
            this.assertPostErrorNotification(inEvent, postNotification);
        }
    }

    private void setupMessageProcessorNotificationListener(List<MessageProcessorNotification> notificationList) {
        this.muleContext.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        this.muleContext.getNotificationManager().addListener((NotificationListener)((MessageProcessorNotificationListener)notification -> notificationList.add((MessageProcessorNotification)notification)));
    }

    private void assertPreNotification(CoreEvent inEvent, MessageProcessorNotification preNotification) {
        Assert.assertThat((Object)preNotification.getAction().getActionId(), (Matcher)CoreMatchers.equalTo((Object)1601));
        Assert.assertThat((Object)preNotification.getEventContext(), (Matcher)CoreMatchers.equalTo((Object)inEvent.getContext()));
        Assert.assertThat((Object)preNotification.getEvent(), (Matcher)CoreMatchers.equalTo((Object)inEvent));
        Assert.assertThat((Object)preNotification.getException(), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    private void assertPostErrorNotification(CoreEvent inEvent, MessageProcessorNotification postNotification) {
        Assert.assertThat((Object)postNotification.getEvent(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)inEvent)));
        Assert.assertThat((Object)postNotification.getEvent().getError().isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((Error)postNotification.getEvent().getError().get()).getCause(), (Matcher)Is.is((Object)this.illegalStateException));
        Assert.assertThat((Object)postNotification.getException(), (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
        Assert.assertThat((Object)postNotification.getException().getCause(), (Matcher)Is.is((Object)this.illegalStateException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreEvent process(Processor messageProcessor, CoreEvent event) throws Exception {
        if (messageProcessor instanceof MuleContextAware) {
            ((MuleContextAware)messageProcessor).setMuleContext(this.muleContext);
        }
        try {
            CoreEvent coreEvent = super.process(messageProcessor, event);
            return coreEvent;
        }
        finally {
            SchedulerService schedulerService = this.muleContext.getSchedulerService();
        }
    }

    private AppendingMP getAppendingMP(String append) {
        return new NonBlockingAppendingMP(append);
    }

    private void assertLifecycle(AppendingInterceptingMP mp) {
        Assert.assertTrue((boolean)mp.muleContextInjected);
        Assert.assertTrue((boolean)mp.initialised);
        Assert.assertTrue((boolean)mp.started);
        Assert.assertTrue((boolean)mp.stopped);
        Assert.assertTrue((boolean)mp.disposed);
    }

    protected CoreEvent getTestEventUsingFlow(Object data) throws MuleException {
        return CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)data)).build();
    }

    public static class ExceptionThrowingMessageProcessor
    extends AbstractComponent
    implements Processor,
    InternalProcessor {
        private Exception exception;

        public ExceptionThrowingMessageProcessor(Exception exception) {
            this.exception = exception;
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            if (this.exception instanceof MuleException) {
                throw (MuleException)((Object)this.exception);
            }
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new MuleRuntimeException((Throwable)this.exception);
        }

        public ComponentLocation getLocation() {
            return (ComponentLocation)Mockito.mock(ComponentLocation.class);
        }
    }

    static class ReturnVoidMPInterceptongMP
    extends AbstractInterceptingMessageProcessor {
        ReturnVoidMPInterceptongMP() {
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return event;
        }
    }

    private static class ReturnVoidMP
    implements Processor {
        CoreEvent event;

        private ReturnVoidMP() {
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            this.event = event;
            return event;
        }
    }

    static class ReturnNullInterceptongMP
    extends AbstractInterceptingMessageProcessor {
        ReturnNullInterceptongMP() {
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return null;
        }
    }

    static class ReturnNullMP
    implements Processor {
        CoreEvent event;

        ReturnNullMP() {
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            this.event = event;
            return null;
        }
    }

    class AppendingInterceptingMP
    extends AbstractInterceptingMessageProcessor
    implements Lifecycle {
        String appendString;
        boolean muleContextInjected;
        boolean initialised;
        boolean started;
        boolean stopped;
        boolean disposed;
        private boolean stopProcessing;
        boolean invoked;

        public AppendingInterceptingMP(String appendString) {
            this(appendString, false);
        }

        public AppendingInterceptingMP(String appendString, boolean stopProcessing) {
            this.appendString = appendString;
            this.stopProcessing = stopProcessing;
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
        }

        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            if (this.stopProcessing) {
                return publisher;
            }
            return Flux.from(publisher).map(before -> this.appendBefore((CoreEvent)before)).transform((Function)this.applyNext()).map(after -> {
                if (after != null) {
                    return this.appendAfter((CoreEvent)after);
                }
                return after;
            });
        }

        private CoreEvent appendAfter(CoreEvent after) {
            return CoreEvent.builder((CoreEvent)after).message(Message.of((Object)(after.getMessage().getPayload().getValue() + "after" + this.appendString))).build();
        }

        private CoreEvent appendBefore(CoreEvent before) {
            return CoreEvent.builder((CoreEvent)before).message(Message.of((Object)(before.getMessage().getPayload().getValue() + "before" + this.appendString))).build();
        }

        public void initialise() throws InitialisationException {
            this.initialised = true;
        }

        public void start() throws MuleException {
            this.started = true;
        }

        public void stop() throws MuleException {
            this.stopped = true;
        }

        public void dispose() {
            this.disposed = true;
        }

        public String toString() {
            return ObjectUtils.toString((Object)((Object)this));
        }

        public void setMuleContext(MuleContext context) {
            this.muleContextInjected = true;
            super.setMuleContext(context);
        }
    }

    class AppendingMP
    extends AbstractComponent
    implements Processor,
    Lifecycle,
    MuleContextAware {
        String appendString;
        boolean muleContextInjected;
        boolean flowConstuctInjected;
        boolean initialised;
        boolean started;
        boolean stopped;
        boolean disposed;
        CoreEvent event;
        CoreEvent resultEvent;

        public AppendingMP(String append) {
            this.appendString = append;
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return this.innerProcess(event);
        }

        private CoreEvent innerProcess(CoreEvent event) {
            CoreEvent result;
            this.event = event;
            this.resultEvent = result = CoreEvent.builder((CoreEvent)event).message(Message.of((Object)(event.getMessage().getPayload().getValue() + this.appendString))).build();
            return result;
        }

        public void initialise() throws InitialisationException {
            this.initialised = true;
        }

        public void start() throws MuleException {
            this.started = true;
        }

        public void stop() throws MuleException {
            this.stopped = true;
        }

        public void dispose() {
            this.disposed = true;
        }

        public String toString() {
            return ObjectUtils.toString((Object)((Object)this));
        }

        public void setMuleContext(MuleContext context) {
            this.muleContextInjected = true;
        }

        public ComponentLocation getLocation() {
            return (ComponentLocation)Mockito.mock(ComponentLocation.class);
        }
    }

    class NonBlockingAppendingMP
    extends AppendingMP {
        public ReactiveProcessor.ProcessingType getProcessingType() {
            return ReactiveProcessor.ProcessingType.CPU_INTENSIVE;
        }

        public NonBlockingAppendingMP(String append) {
            super(append);
        }

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            DefaultMessageProcessorChainTestCase.this.nonBlockingProcessorsExecuted.incrementAndGet();
            return super.process(event);
        }
    }

    static class TestIntercepting
    extends AbstractInterceptingMessageProcessor {
        TestIntercepting() {
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return this.processNext(CoreEvent.builder((CoreEvent)event).message(Message.of((Object)(event.getMessage().getPayload().getValue() + "InterceptingMessageProcessor"))).build());
        }
    }

    static class TestNonIntercepting
    implements Processor {
        TestNonIntercepting() {
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return CoreEvent.builder((CoreEvent)event).message(Message.of((Object)(event.getMessage().getPayload().getValue() + "MessageProcessor"))).build();
        }
    }
}

