/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.routing.outbound;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.privileged.routing.outbound.AbstractOutboundRouter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class OutboundRouterTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testAddGoodProcessor() throws Exception {
        DummyOutboundRouter router = new DummyOutboundRouter();
        Processor processor = this.getTestMessageProcessor();
        router.addRoute(processor);
        Assert.assertNotNull((Object)router.getRoutes());
        Assert.assertTrue((boolean)router.getRoutes().contains(processor));
    }

    private Processor getTestMessageProcessor() {
        return (Processor)Mockito.mock(Processor.class);
    }

    @Test
    public void testSetGoodProcessors() throws Exception {
        ArrayList<Processor> list = new ArrayList<Processor>();
        list.add(this.getTestMessageProcessor());
        list.add(this.getTestMessageProcessor());
        DummyOutboundRouter router = new DummyOutboundRouter();
        Assert.assertNotNull((Object)router.getRoutes());
        Assert.assertEquals((long)0L, (long)router.getRoutes().size());
        router.addRoute(this.getTestMessageProcessor());
        Assert.assertEquals((long)1L, (long)router.getRoutes().size());
        router.setRoutes(list);
        Assert.assertNotNull((Object)router.getRoutes());
        Assert.assertEquals((long)2L, (long)router.getRoutes().size());
    }

    @Test
    public void testSetBadProcessors() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(Mockito.mock(MessageSource.class));
        list.add(this.getTestMessageProcessor());
        DummyOutboundRouter router = new DummyOutboundRouter();
        try {
            router.setRoutes(list);
            Assert.fail((String)"Invalid endpoint: Expecting an exception");
        }
        catch (Exception e) {
            Assert.assertEquals(ClassCastException.class, e.getClass());
        }
    }

    @Test
    public void testSetBad2Processors() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getTestMessageProcessor());
        list.add(Mockito.mock(MessageSource.class));
        DummyOutboundRouter router = new DummyOutboundRouter();
        try {
            router.setRoutes(list);
            Assert.fail((String)"Invalid endpoint: Expecting an exception");
        }
        catch (Exception e) {
            Assert.assertEquals(ClassCastException.class, e.getClass());
        }
    }

    private static class DummyOutboundRouter
    extends AbstractOutboundRouter {
        private DummyOutboundRouter() {
        }

        public boolean isMatch(CoreEvent event, CoreEvent.Builder builder) throws MuleException {
            return false;
        }

        protected CoreEvent route(CoreEvent event) throws MuleException {
            return null;
        }
    }
}

