/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.util;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.privileged.util.ObjectNameHelper;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ObjectNameHelperTestCase
extends AbstractMuleContextTestCase {
    public static final String UNIQUE_NAME_PREFIX = "unique-name-prefix";

    @Test
    public void uniqueNameGeneration() throws Exception {
        ObjectNameHelper objectNameHelper = new ObjectNameHelper(muleContext);
        String uniqueName = objectNameHelper.getUniqueName(UNIQUE_NAME_PREFIX);
        Assert.assertThat((Object)uniqueName, (Matcher)StringStartsWith.startsWith((String)UNIQUE_NAME_PREFIX));
        String secondUniqueName = objectNameHelper.getUniqueName(UNIQUE_NAME_PREFIX);
        Assert.assertThat((Object)secondUniqueName, (Matcher)StringStartsWith.startsWith((String)UNIQUE_NAME_PREFIX));
        Assert.assertThat((Object)uniqueName, (Matcher)IsNot.not((Matcher)Is.is((Object)secondUniqueName)));
        String nextName = "unique-name-prefix-2";
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject("unique-name-prefix-2", (Object)"");
        String thirdUniqueName = objectNameHelper.getUniqueName(UNIQUE_NAME_PREFIX);
        Assert.assertThat((Object)thirdUniqueName, (Matcher)IsNot.not((Matcher)Is.is((Object)"unique-name-prefix-2")));
    }
}

