/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.util;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.core.privileged.util.TemplateParser;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class TemplateParserSpecialCharactersTestCase
extends AbstractMuleTestCase {
    private Map<String, Object> properties;

    @Before
    public void initializeMap() {
        this.properties = new HashMap<String, Object>();
        this.properties.put("prop1", "12345@$6789");
        this.properties.put("prop2", "12345@$67$89$10$");
        this.properties.put("prop3", "\\12345@\\$67$89$10$12\\");
    }

    @Test
    public void testValueWithADollarSign() {
        TemplateParser templateParser = TemplateParser.createAntStyleParser();
        String template = "${prop1}";
        String result = templateParser.parse(this.properties, template);
        Assert.assertEquals((Object)"12345@$6789", (Object)result);
    }

    @Test
    public void testTemplateWithManyDollarSign() {
        TemplateParser templateParser = TemplateParser.createAntStyleParser();
        String template = "${prop2}";
        String result = templateParser.parse(this.properties, template);
        Assert.assertEquals((Object)"12345@$67$89$10$", (Object)result);
    }

    @Test
    public void testTemplateWithDollarSignsAndBackSlashes() {
        TemplateParser templateParser = TemplateParser.createAntStyleParser();
        String template = "${prop3}";
        String result = templateParser.parse(this.properties, template);
        Assert.assertEquals((Object)"\\12345@\\$67$89$10$12\\", (Object)result);
    }
}

