/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.io.Serializable;
import java.time.OffsetTime;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.core.AbstractEventContext;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ProcessorsTrace;
import org.mule.runtime.core.context.notification.DefaultProcessorsTrace;
import org.mule.runtime.core.management.stats.ProcessingTime;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class DefaultEventContext
extends AbstractEventContext
implements Serializable {
    private static final long serialVersionUID = -3664490832964509653L;
    private final String id;
    private final String correlationId;
    private final OffsetTime receivedDate = OffsetTime.now();
    private final String serverId;
    private final ComponentLocation location;
    private final String flowName;
    private final String connectorName;
    private final String sourceName;
    private final ProcessingTime processingTime;
    private final ProcessorsTrace processorsTrace = new DefaultProcessorsTrace();

    public static EventContext create(FlowConstruct flow, ComponentLocation location) {
        return DefaultEventContext.create(flow, location, null);
    }

    public static EventContext create(FlowConstruct flow, ComponentLocation location, String correlationId) {
        return DefaultEventContext.create(flow, location, correlationId, (Publisher<Void>)Mono.empty());
    }

    public static EventContext create(FlowConstruct flow, ComponentLocation location, String correlationId, Publisher<Void> externalCompletionPublisher) {
        return new DefaultEventContext(flow, location, correlationId, externalCompletionPublisher);
    }

    public static EventContext child(EventContext parent) {
        ChildEventContext child = new ChildEventContext(parent);
        if (parent instanceof AbstractEventContext) {
            ((AbstractEventContext)parent).addChildContext(child);
        }
        return child;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId != null ? this.correlationId : this.id;
    }

    @Override
    public OffsetTime getReceivedTime() {
        return this.receivedDate;
    }

    @Override
    public ComponentLocation getOriginatingLocation() {
        return this.location;
    }

    @Override
    public String getOriginatingFlowName() {
        return this.flowName;
    }

    @Override
    public String getOriginatingConnectorName() {
        return this.connectorName;
    }

    @Override
    public String getOriginatingSourceName() {
        return this.sourceName;
    }

    @Override
    public ProcessingTime getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public boolean isCorrelationIdFromSource() {
        return this.correlationId != null;
    }

    @Override
    public ProcessorsTrace getProcessorsTrace() {
        return this.processorsTrace;
    }

    @Override
    public Optional<EventContext> getParentContext() {
        return Optional.empty();
    }

    private DefaultEventContext(FlowConstruct flow, ComponentLocation location, String correlationId, Publisher<Void> externalCompletionPublisher) {
        super(externalCompletionPublisher);
        this.id = flow.getUniqueIdString();
        this.serverId = flow.getServerId();
        this.flowName = flow.getName();
        this.location = location;
        this.connectorName = location.getComponentIdentifier().getIdentifier().getNamespace();
        this.sourceName = location.getComponentIdentifier().getIdentifier().getName();
        this.processingTime = ProcessingTime.newInstance(flow);
        this.correlationId = correlationId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { id: " + this.id + "; correlationId: " + this.correlationId + "; flowName: " + this.flowName + "; serverId: " + this.serverId + " }";
    }

    private static class ChildEventContext
    extends AbstractEventContext
    implements Serializable {
        private static final long serialVersionUID = 1054412872901205234L;
        private final EventContext parent;

        private ChildEventContext(EventContext parent) {
            super((Publisher<Void>)Mono.empty());
            this.parent = parent;
        }

        @Override
        public String getId() {
            return this.parent.getId() + System.identityHashCode(this);
        }

        @Override
        public String getCorrelationId() {
            return this.parent.getCorrelationId();
        }

        @Override
        public OffsetTime getReceivedTime() {
            return this.parent.getReceivedTime();
        }

        @Override
        public ComponentLocation getOriginatingLocation() {
            return this.parent.getOriginatingLocation();
        }

        @Override
        public String getOriginatingFlowName() {
            return this.parent.getOriginatingFlowName();
        }

        @Override
        public String getOriginatingConnectorName() {
            return this.parent.getOriginatingConnectorName();
        }

        @Override
        public String getOriginatingSourceName() {
            return this.parent.getOriginatingSourceName();
        }

        @Override
        public ProcessingTime getProcessingTime() {
            return this.parent.getProcessingTime();
        }

        @Override
        public ProcessorsTrace getProcessorsTrace() {
            return this.parent.getProcessorsTrace();
        }

        @Override
        public boolean isCorrelationIdFromSource() {
            return this.parent.isCorrelationIdFromSource();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " { id: " + this.parent.getId() + "; correlationId: " + this.parent.getCorrelationId() + "; flowName: " + this.parent.getOriginatingFlowName() + " }";
        }

        @Override
        public Optional<EventContext> getParentContext() {
            return Optional.of(this.parent);
        }
    }
}

