/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.functional;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Either<L, R> {
    private final Optional<L> left;
    private final Optional<R> right;

    public static <L, R> Either<L, R> left(L value) {
        return new Either(Optional.ofNullable(value), Optional.empty());
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Either(Optional.empty(), Optional.ofNullable(value));
    }

    private Either(Optional<L> l, Optional<R> r) {
        this.left = l;
        this.right = r;
    }

    public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> func) {
        return new Either<T, R>(this.left.map(func), this.right);
    }

    public void applyLeft(Consumer<? super L> consumer) {
        this.left.ifPresent(consumer::accept);
    }

    public void applyRight(Consumer<? super R> consumer) {
        this.right.ifPresent(consumer::accept);
    }

    public <T> Either<L, T> mapRight(Function<? super R, ? extends T> func) {
        return new Either<L, T>(this.left, this.right.map(func));
    }

    public void apply(Consumer<? super L> leftFunc, Consumer<? super R> rightFunc) {
        this.applyLeft(leftFunc);
        this.applyRight(rightFunc);
    }

    public boolean isLeft() {
        return this.left.isPresent();
    }

    public boolean isRight() {
        return this.right.isPresent();
    }

    public L getLeft() {
        return this.left.orElse(null);
    }

    public R getRight() {
        return this.right.orElse(null);
    }

    public Optional<Object> getValue() {
        if (this.left.isPresent()) {
            return this.left;
        }
        if (this.right.isPresent()) {
            return this.right;
        }
        return Optional.empty();
    }

    public String toString() {
        return String.format("%s - left: { %s }; right: { %s }", this.getClass().getSimpleName(), this.left.toString(), this.right.toString());
    }
}

