/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.util.OrderedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesUtils.class);
    private static final List<String> maskedProperties = new CopyOnWriteArrayList<String>();

    protected PropertiesUtils() {
    }

    public static void registerMaskedPropertyName(String name) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Cannot mask empty property name.");
        }
        maskedProperties.add(name);
    }

    public static String maskedPropertyValue(Map.Entry<?, ?> property) {
        if (property == null) {
            return null;
        }
        Object key = property.getKey();
        Object value = property.getValue();
        if (key == null || value == null) {
            return null;
        }
        if (maskedProperties.contains(key)) {
            return "*****";
        }
        return value.toString();
    }

    public static synchronized Properties loadProperties(String fileName, Class<?> callingClass) throws IOException {
        InputStream is = IOUtils.getResourceAsStream(fileName, callingClass, true, false);
        if (is == null) {
            I18nMessage error = CoreMessages.cannotLoadFromClasspath(fileName);
            throw new IOException(error.toString());
        }
        return PropertiesUtils.loadProperties(is);
    }

    public static Properties loadProperties(URL url) throws IOException {
        if (url == null) {
            I18nMessage error = CoreMessages.objectIsNull("url");
            throw new IOException(error.toString());
        }
        return PropertiesUtils.loadProperties(url.openStream());
    }

    public static Properties loadAllProperties(String fileName, ClassLoader classLoader) {
        Properties p = new Properties();
        ArrayList<URL> resourcesUrl = new ArrayList<URL>();
        try {
            Enumeration<URL> resources = classLoader.getResources(fileName);
            while (resources.hasMoreElements()) {
                resourcesUrl.add(resources.nextElement());
            }
            Collections.sort(resourcesUrl, (url, url1) -> {
                if ("file".equals(url.getProtocol())) {
                    return 1;
                }
                return -1;
            });
            for (URL resourceUrl : resourcesUrl) {
                InputStream in = resourceUrl.openStream();
                p.load(in);
                in.close();
            }
        }
        catch (IOException e) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)("Failed to load resource: " + fileName)), (Throwable)e);
        }
        return p;
    }

    public static Properties loadProperties(InputStream is) throws IOException {
        if (is == null) {
            I18nMessage error = CoreMessages.objectIsNull("input stream");
            throw new IOException(error.toString());
        }
        try {
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        finally {
            is.close();
        }
    }

    public static String removeXmlNamespacePrefix(String eleName) {
        int i = eleName.indexOf(58);
        return i == -1 ? eleName : eleName.substring(i + 1, eleName.length());
    }

    public static String removeNamespacePrefix(String eleName) {
        int i = eleName.lastIndexOf(46);
        return i == -1 ? eleName : eleName.substring(i + 1, eleName.length());
    }

    public static Map removeNamespaces(Map properties) {
        HashMap props = new HashMap(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            props.put(PropertiesUtils.removeNamespacePrefix((String)entry.getKey()), entry.getValue());
        }
        return props;
    }

    public static void getPropertiesWithPrefix(Map props, String prefix, Map newProps) {
        if (props == null) {
            return;
        }
        for (Map.Entry entry : props.entrySet()) {
            Object key = entry.getKey();
            if (!key.toString().startsWith(prefix)) continue;
            newProps.put(key, entry.getValue());
        }
    }

    public static Properties getPropertiesFromQueryString(String query) {
        Properties props = new Properties();
        if (StringUtils.isEmpty(query)) {
            return props;
        }
        query = new StringBuilder(query.length() + 1).append('&').append(query).toString();
        int x = 0;
        while ((x = PropertiesUtils.addProperty(query, x, '&', props)) != -1) {
        }
        return props;
    }

    public static Properties getPropertiesFromString(String query, char separator) {
        Properties props = new Properties();
        if (query == null) {
            return props;
        }
        query = new StringBuilder(query.length() + 1).append(separator).append(query).toString();
        int x = 0;
        while ((x = PropertiesUtils.addProperty(query, x, separator, props)) != -1) {
        }
        return props;
    }

    private static int addProperty(String query, int start, char separator, Properties properties) {
        String pair;
        int i = query.indexOf(separator, start);
        int i2 = query.indexOf(separator, i + 1);
        if (i > -1 && i2 > -1) {
            pair = query.substring(i + 1, i2);
        } else if (i > -1) {
            pair = query.substring(i + 1);
        } else {
            return -1;
        }
        int eq = pair.indexOf(61);
        if (eq <= 0) {
            String key = pair;
            String value = "";
            properties.setProperty(key, value);
        } else {
            String key = pair.substring(0, eq);
            String value = eq == pair.length() ? "" : pair.substring(eq + 1);
            properties.setProperty(key, value);
        }
        return i2;
    }

    public static List<Properties> discoverProperties(String resource) throws IOException {
        return PropertiesUtils.discoverProperties(PropertiesUtils.class.getClassLoader(), resource);
    }

    public static List<Properties> discoverProperties(ClassLoader classLoader, String resource) throws IOException {
        Preconditions.checkArgument((!StringUtils.isEmpty(resource) ? 1 : 0) != 0, (String)"Resource cannot be empty");
        Preconditions.checkArgument((classLoader != null ? 1 : 0) != 0, (String)"ClassLoader cannot be null");
        LinkedList<Properties> result = new LinkedList<Properties>();
        Enumeration<URL> allPropertiesResources = classLoader.getResources(resource);
        while (allPropertiesResources.hasMoreElements()) {
            URL propertiesResource = allPropertiesResources.nextElement();
            if (logger.isDebugEnabled()) {
                logger.debug("Reading properties from: " + propertiesResource.toString());
            }
            OrderedProperties properties = new OrderedProperties();
            try (InputStream resourceStream = propertiesResource.openStream();){
                properties.load(resourceStream);
            }
            result.add(properties);
        }
        return result;
    }

    static {
        PropertiesUtils.registerMaskedPropertyName("password");
    }
}

