/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.collection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

class ImmutableListCollector<T>
implements Collector<T, ImmutableList.Builder<T>, List<T>> {
    ImmutableListCollector() {
    }

    @Override
    public Supplier<ImmutableList.Builder<T>> supplier() {
        return ImmutableList::builder;
    }

    @Override
    public BiConsumer<ImmutableList.Builder<T>, T> accumulator() {
        return (builder, value) -> builder.add(value);
    }

    @Override
    public BinaryOperator<ImmutableList.Builder<T>> combiner() {
        return (left, right) -> {
            left.addAll((Iterable)right.build());
            return left;
        };
    }

    @Override
    public Function<ImmutableList.Builder<T>, List<T>> finisher() {
        return ImmutableList.Builder::build;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return ImmutableSet.of();
    }
}

