/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.context.notification;

import java.util.HashMap;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.context.notification.EnrichedServerNotification;
import org.mule.runtime.core.api.context.notification.SynchronousServerEvent;
import org.mule.runtime.core.api.transaction.Transaction;

public class TransactionNotification
extends EnrichedServerNotification
implements SynchronousServerEvent {
    private static final long serialVersionUID = -3245036187011582121L;
    private static String UNKNOWN_APPLICATION_NAME = "unknown";
    public static final int TRANSACTION_BEGAN = 1201;
    public static final int TRANSACTION_COMMITTED = 1202;
    public static final int TRANSACTION_ROLLEDBACK = 1203;
    private String applicationName;
    private String transactionStringId;

    public TransactionNotification(Transaction transaction, int action) {
        this(transaction, action, UNKNOWN_APPLICATION_NAME);
    }

    public TransactionNotification(Transaction transaction, int action, String applicationName) {
        super(TransactionNotification.emptyInfo(), action, transaction.getId());
        this.transactionStringId = transaction.getId();
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getTransactionStringId() {
        return this.transactionStringId;
    }

    @Override
    public String toString() {
        return this.EVENT_NAME + "{action=" + TransactionNotification.getActionName(this.action) + ", transactionStringId=" + this.transactionStringId + ", timestamp=" + this.timestamp + "}";
    }

    private static EnrichedNotificationInfo emptyInfo() {
        return new EnrichedNotificationInfo(null, null, null, null, null, null, null, new HashMap<String, TypedValue>(), null, null);
    }

    static {
        TransactionNotification.registerAction("begin", 1201);
        TransactionNotification.registerAction("commit", 1202);
        TransactionNotification.registerAction("rollback", 1203);
    }
}

