/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.metadata.TypedValue;

public class DefaultBindingContextBuilder
implements BindingContext.Builder {
    private Map<String, TypedValue> bindings;
    private List<ExpressionModule> modules;

    public DefaultBindingContextBuilder() {
        this.bindings = new HashMap<String, TypedValue>();
        this.modules = new ArrayList<ExpressionModule>();
    }

    public DefaultBindingContextBuilder(BindingContext bindingContext) {
        this.bindings = bindingContext.identifiers().stream().collect(Collectors.toMap(id -> id, id -> (TypedValue)bindingContext.lookup(id).get()));
        this.modules = new ArrayList<ExpressionModule>(bindingContext.modules());
    }

    public BindingContext.Builder addBinding(String identifier, TypedValue value) {
        this.bindings.put(identifier, value);
        return this;
    }

    public BindingContext.Builder addAll(BindingContext context) {
        context.identifiers().forEach(id -> this.bindings.put((String)id, (TypedValue)context.lookup(id).get()));
        this.modules.addAll(context.modules());
        return this;
    }

    public BindingContext.Builder addModule(ExpressionModule expressionModule) {
        this.modules.add(expressionModule);
        return this;
    }

    public BindingContext build() {
        return new BindingContextImplementation(this.bindings, this.modules);
    }

    private class BindingContextImplementation
    implements BindingContext {
        private Map<String, TypedValue> bindings;
        private List<ExpressionModule> modules;

        private BindingContextImplementation(Map<String, TypedValue> bindings, List<ExpressionModule> modules) {
            this.bindings = Collections.unmodifiableMap(new HashMap<String, TypedValue>(bindings));
            this.modules = Collections.unmodifiableList(new ArrayList<ExpressionModule>(modules));
        }

        public Collection<Binding> bindings() {
            return this.bindings.entrySet().stream().map(entry -> new Binding((String)entry.getKey(), (TypedValue)entry.getValue())).collect(Collectors.toList());
        }

        public Collection<String> identifiers() {
            return this.bindings.keySet();
        }

        public Optional<TypedValue> lookup(String identifier) {
            return Optional.ofNullable(this.bindings.get(identifier));
        }

        public Collection<ExpressionModule> modules() {
            return this.modules;
        }
    }
}

