/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel.datatype;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.el.mvel.datatype.EnricherDataTypePropagator;
import org.mule.runtime.core.el.mvel.datatype.FlowVarEnricherDataTypePropagator;
import org.mule.runtime.core.el.mvel.datatype.PayloadEnricherDataTypePropagator;
import org.mule.runtime.core.el.mvel.datatype.PropertyEnricherDataTypePropagator;
import org.mule.runtime.core.el.mvel.datatype.SessionVarEnricherDataTypePropagator;

public class MvelEnricherDataTypePropagator {
    private final List<EnricherDataTypePropagator> propagators;

    public MvelEnricherDataTypePropagator() {
        this(MvelEnricherDataTypePropagator.getDefaultDataTypePropagators());
    }

    public MvelEnricherDataTypePropagator(List<EnricherDataTypePropagator> propagators) {
        this.propagators = new LinkedList<EnricherDataTypePropagator>(propagators);
    }

    private static List<EnricherDataTypePropagator> getDefaultDataTypePropagators() {
        LinkedList<EnricherDataTypePropagator> propagators = new LinkedList<EnricherDataTypePropagator>();
        propagators.add(new PayloadEnricherDataTypePropagator());
        propagators.add(new PropertyEnricherDataTypePropagator());
        propagators.add(new FlowVarEnricherDataTypePropagator());
        propagators.add(new SessionVarEnricherDataTypePropagator());
        return propagators;
    }

    public void propagate(TypedValue typedValue, Event event, Event.Builder builder, Serializable serializedExpression) {
        if (serializedExpression instanceof CompiledExpression) {
            CompiledExpression compiledExpression = (CompiledExpression)serializedExpression;
            for (EnricherDataTypePropagator propagator : this.propagators) {
                if (!propagator.propagate(event, builder, typedValue, compiledExpression)) continue;
                return;
            }
        }
    }
}

