/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.interceptor;

import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.interceptor.Interceptor;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;

public class InterceptorStack
extends AbstractInterceptingMessageProcessor
implements Interceptor,
Initialisable,
Disposable {
    private List<Interceptor> interceptors;
    private MessageProcessorChain chain;

    public InterceptorStack() {
    }

    public InterceptorStack(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public Event process(Event event) throws MuleException {
        return this.chain.process(event);
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void initialise() throws InitialisationException {
        DefaultMessageProcessorChainBuilder chainBuilder = new DefaultMessageProcessorChainBuilder();
        chainBuilder.setName("interceptor stack");
        for (Interceptor interceptor : this.interceptors) {
            if (interceptor instanceof Initialisable) {
                ((Initialisable)interceptor).initialise();
            }
            chainBuilder.chain(interceptor);
        }
        if (this.next != null) {
            chainBuilder.chain(this.next);
        }
        this.chain = chainBuilder.build();
        this.chain.setMuleContext(this.muleContext);
        this.chain.setFlowConstruct(this.flowConstruct);
        this.chain.initialise();
    }

    public void dispose() {
        for (Interceptor interceptor : this.interceptors) {
            if (!(interceptor instanceof Disposable)) continue;
            ((Disposable)interceptor).dispose();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interceptors == null ? 0 : this.interceptors.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterceptorStack other = (InterceptorStack)obj;
        return !(this.interceptors == null ? other.interceptors != null : !this.interceptors.equals(other.interceptors));
    }
}

