/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.streaming.CursorManager;
import org.mule.runtime.core.internal.streaming.ManagedCursorProvider;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.DefaultByteStreamingManager;
import org.mule.runtime.core.internal.streaming.bytes.PoolingByteBufferManager;
import org.mule.runtime.core.internal.streaming.object.DefaultObjectStreamingManager;
import org.mule.runtime.core.streaming.StreamingManager;
import org.mule.runtime.core.streaming.StreamingStatistics;
import org.mule.runtime.core.streaming.bytes.ByteStreamingManager;
import org.mule.runtime.core.streaming.object.ObjectStreamingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamingManager
implements StreamingManager,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStreamingManager.class);
    private ByteBufferManager bufferManager;
    private ByteStreamingManager byteStreamingManager;
    private ObjectStreamingManager objectStreamingManager;
    private CursorManager cursorManager;
    private MutableStreamingStatistics statistics;
    private boolean initialised = false;
    @Inject
    private MuleContext muleContext;

    public void initialise() throws InitialisationException {
        if (!this.initialised) {
            this.statistics = new MutableStreamingStatistics();
            this.cursorManager = new CursorManager(this.statistics);
            this.bufferManager = new PoolingByteBufferManager();
            this.byteStreamingManager = this.createByteStreamingManager();
            this.objectStreamingManager = this.createObjectStreamingManager();
            LifecycleUtils.initialiseIfNeeded((Object)this.byteStreamingManager, true, this.muleContext);
            LifecycleUtils.initialiseIfNeeded((Object)this.objectStreamingManager, true, this.muleContext);
            this.initialised = true;
        }
    }

    protected ByteStreamingManager createByteStreamingManager() {
        return new DefaultByteStreamingManager(this.bufferManager, this);
    }

    protected ObjectStreamingManager createObjectStreamingManager() {
        return new DefaultObjectStreamingManager(this);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.byteStreamingManager, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.objectStreamingManager, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.bufferManager, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.cursorManager, LOGGER);
        this.initialised = false;
    }

    @Override
    public ByteStreamingManager forBytes() {
        return this.byteStreamingManager;
    }

    @Override
    public ObjectStreamingManager forObjects() {
        return this.objectStreamingManager;
    }

    @Override
    public CursorProvider manage(CursorProvider provider, Event creatorEvent) {
        if (provider instanceof ManagedCursorProvider) {
            return provider;
        }
        return this.cursorManager.manage(provider, creatorEvent);
    }

    @Override
    public StreamingStatistics getStreamingStatistics() {
        return this.statistics;
    }

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }
}

