/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes.factory;

import java.io.InputStream;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.streaming.StreamingManager;
import org.mule.runtime.core.streaming.bytes.CursorStreamProviderFactory;

public abstract class AbstractCursorStreamProviderFactory
implements CursorStreamProviderFactory {
    private final ByteBufferManager bufferManager;
    private final StreamingManager streamingManager;

    protected AbstractCursorStreamProviderFactory(ByteBufferManager bufferManager, StreamingManager streamingManager) {
        this.bufferManager = bufferManager;
        this.streamingManager = streamingManager;
    }

    @Override
    public final Object of(Event event, InputStream inputStream) {
        if (inputStream instanceof CursorStream) {
            return this.streamingManager.manage(((CursorStream)inputStream).getProvider(), event);
        }
        Object value = this.resolve(inputStream, event);
        if (value instanceof CursorStreamProvider) {
            value = this.streamingManager.manage((CursorProvider)((CursorStreamProvider)value), event);
        }
        return value;
    }

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }

    protected abstract Object resolve(InputStream var1, Event var2);
}

