/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.chain;

import java.util.List;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.processor.chain.ExplicitMessageProcessorChainBuilder;
import org.mule.runtime.core.processor.chain.SubFlowMessageProcessor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SubflowMessageProcessorChainBuilder
extends ExplicitMessageProcessorChainBuilder {
    @Override
    protected MessageProcessorChain createInterceptingChain(Processor head, List<Processor> processors, List<Processor> processorForLifecycle) {
        return new SubflowMessageProcessorChain(this.name, head, processors, processorForLifecycle);
    }

    static class SubflowMessageProcessorChain
    extends ExplicitMessageProcessorChainBuilder.ExplicitMessageProcessorChain
    implements SubFlowMessageProcessor {
        private String subFlowName;

        SubflowMessageProcessorChain(String name, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
            super(name, head, processors, processorsForLifecycle);
            this.subFlowName = name;
        }

        @Override
        public Event process(Event event) throws MuleException {
            this.pushSubFlowFlowStackElement().accept(event);
            try {
                Event event2 = super.process(event);
                return event2;
            }
            finally {
                this.popSubFlowFlowStackElement().accept(event);
            }
        }

        private Consumer<Event> pushSubFlowFlowStackElement() {
            return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(this.getSubFlowName(), null));
        }

        private Consumer<Event> popSubFlowFlowStackElement() {
            return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
        }

        @Override
        public Publisher<Event> apply(Publisher<Event> publisher) {
            return Flux.from(publisher).concatMap(event -> Mono.just((Object)event).doOnNext(this.pushSubFlowFlowStackElement()).transform(s -> super.apply((Publisher<Event>)s)).doOnTerminate((event1, throwable) -> this.popSubFlowFlowStackElement().accept((Event)event)));
        }

        @Override
        public String getSubFlowName() {
            return this.subFlowName;
        }
    }
}

