/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.routing.AbstractRoutingStrategy;
import org.mule.runtime.core.routing.RoutingFailedException;
import org.mule.runtime.core.routing.filters.ExpressionFilter;

public class FirstSuccessfulRoutingStrategy
extends AbstractRoutingStrategy {
    protected ExpressionFilter failureExpressionFilter;
    private RouteProcessor processor;

    public FirstSuccessfulRoutingStrategy(MuleContext muleContext, String failureExpression, RouteProcessor processor) {
        super(muleContext);
        this.failureExpressionFilter = failureExpression != null ? new ExpressionFilter(failureExpression) : new ExpressionFilter("mel:exception != null");
        this.failureExpressionFilter.setMuleContext(muleContext);
        this.processor = processor;
    }

    @Override
    public Event route(Event event, List<Processor> messageProcessors) throws MuleException {
        Event returnEvent = null;
        boolean failed = true;
        Exception failExceptionCause = null;
        for (Processor mp : messageProcessors) {
            try {
                Event toProcess = this.cloneEventForRouting(event, mp);
                returnEvent = this.processor.processRoute(mp, toProcess);
                if (returnEvent == null) {
                    failed = false;
                } else if (returnEvent.getMessage() == null) {
                    failed = true;
                } else {
                    Event.Builder builder = Event.builder(returnEvent);
                    failed = returnEvent == null || this.failureExpressionFilter.accept(returnEvent, builder);
                    returnEvent = builder.build();
                }
            }
            catch (Exception ex) {
                failed = true;
                failExceptionCause = ex;
            }
            if (failed) continue;
            break;
        }
        if (failed) {
            if (failExceptionCause != null) {
                throw new RoutingFailedException(I18nMessageFactory.createStaticMessage((String)"all message processor failed during first successful routing strategy"), failExceptionCause);
            }
            throw new RoutingFailedException(I18nMessageFactory.createStaticMessage((String)"all message processor failed during first successful routing strategy"));
        }
        return returnEvent;
    }

    private Event cloneEventForRouting(Event event, Processor mp) throws MuleException {
        FirstSuccessfulRoutingStrategy.validateMessageIsNotConsumable(event, event.getMessage());
        return this.createEventToRoute(event, event.getMessage(), mp);
    }

    static interface RouteProcessor {
        public Event processRoute(Processor var1, Event var2) throws MuleException;
    }
}

