/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.graph;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.transformer.CompositeConverter;
import org.mule.runtime.core.transformer.graph.TransformationEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationGraphLookupStrategy {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DirectedGraph<DataType, TransformationEdge> graph;

    public TransformationGraphLookupStrategy(DirectedGraph<DataType, TransformationEdge> graph) {
        this.graph = graph;
    }

    public List<Converter> lookupConverters(DataType source, DataType target) {
        List<Converter> converters = new LinkedList<Converter>();
        if (!this.graph.containsVertex((Object)source)) {
            return converters;
        }
        if (!this.graph.containsVertex((Object)target)) {
            return converters;
        }
        HashSet<DataType> visited = new HashSet<DataType>();
        List<List<TransformationEdge>> transformationPaths = this.findTransformationPaths(source, target, visited);
        converters = this.createConverters(transformationPaths);
        return converters;
    }

    private List<Converter> createConverters(List<List<TransformationEdge>> transformationPaths) {
        LinkedList<Converter> converters = new LinkedList<Converter>();
        for (List<TransformationEdge> transformationPath : transformationPaths) {
            Converter[] pathConverters = new Converter[transformationPath.size()];
            int index = 0;
            for (TransformationEdge edge : transformationPath) {
                pathConverters[index++] = edge.getConverter();
            }
            Converter converter = transformationPath.size() == 1 ? transformationPath.get(0).getConverter() : new CompositeConverter(pathConverters);
            converters.add(converter);
        }
        return converters;
    }

    private List<List<TransformationEdge>> findTransformationPaths(DataType source, DataType target, Set<DataType> visited) {
        LinkedList<List<TransformationEdge>> validTransformationEdges = new LinkedList<List<TransformationEdge>>();
        if (visited.contains(source)) {
            return validTransformationEdges;
        }
        visited.add(source);
        Set transformationEdges = this.graph.outgoingEdgesOf((Object)source);
        for (TransformationEdge transformationEdge : transformationEdges) {
            DataType edgeTarget = (DataType)this.graph.getEdgeTarget((Object)transformationEdge);
            if (edgeTarget.equals(target)) {
                LinkedList<TransformationEdge> transformationEdges1 = new LinkedList<TransformationEdge>();
                transformationEdges1.add(transformationEdge);
                validTransformationEdges.add(transformationEdges1);
                continue;
            }
            List<List<TransformationEdge>> newTransformations = this.findTransformationPaths(edgeTarget, target, visited);
            for (List<TransformationEdge> transformationEdgeList : newTransformations) {
                transformationEdgeList.add(0, transformationEdge);
                validTransformationEdges.add(transformationEdgeList);
            }
        }
        visited.remove(source);
        return validTransformationEdges;
    }
}

