/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.nio.charset.Charset;
import java.util.Map;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class MapLookup
extends AbstractTransformer {
    protected volatile Object key;

    public MapLookup() {
        this.registerSourceType(DataType.fromType(Map.class));
        this.setReturnDataType(DataType.OBJECT);
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        if (src instanceof Map) {
            if (this.key != null) {
                return ((Map)src).get(this.key);
            }
            throw new TransformerException(I18nMessageFactory.createStaticMessage((String)"Property 'key' must be set in order to use this transformer."));
        }
        throw new TransformerException(I18nMessageFactory.createStaticMessage((String)"Message to transform must be of type java.util.Map"));
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }
}

