/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.queue;

import java.io.Serializable;
import java.util.Collection;
import org.mule.runtime.core.util.queue.QueueStoreDelegate;

public abstract class AbstractQueueStoreDelegate
implements QueueStoreDelegate {
    private final int capacity;

    public AbstractQueueStoreDelegate(int capacity) {
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void putNow(Serializable o) {
        AbstractQueueStoreDelegate abstractQueueStoreDelegate = this;
        synchronized (abstractQueueStoreDelegate) {
            this.add(o);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean offer(Serializable o, int room, long timeout) throws InterruptedException {
        this.checkInterrupted();
        AbstractQueueStoreDelegate abstractQueueStoreDelegate = this;
        synchronized (abstractQueueStoreDelegate) {
            if (this.capacity > 0) {
                if (this.capacity <= room) {
                    throw new IllegalStateException("Can not add more objects than the capacity in one time");
                }
                long l1 = timeout > 0L ? System.currentTimeMillis() : 0L;
                long l2 = timeout;
                while (this.getSize() >= this.capacity - room) {
                    if (timeout < 0L) {
                        this.wait(0L);
                        continue;
                    }
                    if (l2 <= 0L) {
                        return false;
                    }
                    this.wait(l2);
                    l2 = timeout - (System.currentTimeMillis() - l1);
                }
            }
            if (o != null) {
                this.add(o);
            }
            this.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Serializable poll(long timeout) throws InterruptedException {
        this.checkInterrupted();
        AbstractQueueStoreDelegate abstractQueueStoreDelegate = this;
        synchronized (abstractQueueStoreDelegate) {
            long l1 = timeout > 0L ? System.currentTimeMillis() : 0L;
            long l2 = timeout;
            while (this.isEmpty()) {
                if (l2 <= 0L) {
                    return null;
                }
                this.wait(l2);
                l2 = timeout - (System.currentTimeMillis() - l1);
            }
            Serializable o = this.removeFirst();
            this.notifyAll();
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Serializable peek() throws InterruptedException {
        this.checkInterrupted();
        AbstractQueueStoreDelegate abstractQueueStoreDelegate = this;
        synchronized (abstractQueueStoreDelegate) {
            if (this.isEmpty()) {
                return null;
            }
            return this.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void untake(Serializable item) throws InterruptedException {
        this.checkInterrupted();
        AbstractQueueStoreDelegate abstractQueueStoreDelegate = this;
        synchronized (abstractQueueStoreDelegate) {
            this.addFirst(item);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() throws InterruptedException {
        this.checkInterrupted();
        AbstractQueueStoreDelegate abstractQueueStoreDelegate = this;
        synchronized (abstractQueueStoreDelegate) {
            this.doClear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addAll(Collection<? extends Serializable> items) {
        AbstractQueueStoreDelegate abstractQueueStoreDelegate = this;
        synchronized (abstractQueueStoreDelegate) {
            boolean result = this.doAddAll(items);
            this.notifyAll();
            return result;
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        AbstractQueueStoreDelegate abstractQueueStoreDelegate = this;
        synchronized (abstractQueueStoreDelegate) {
            return this.size();
        }
    }

    protected abstract int size();

    protected abstract Serializable getFirst() throws InterruptedException;

    protected abstract Serializable removeFirst() throws InterruptedException;

    protected abstract void add(Serializable var1);

    protected abstract void addFirst(Serializable var1) throws InterruptedException;

    protected abstract boolean doAddAll(Collection<? extends Serializable> var1);

    protected abstract void doClear();

    protected abstract boolean isEmpty();
}

