/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.api;

/**
 * Embedded container deployment service.
 * 
 * @since 1.0
 */
public interface DeploymentService {

  /**
   * @param artifactConfiguration application to be deployed
   */
  void deployApplication(ArtifactConfiguration artifactConfiguration);

  /**
   * @param applicationName name of the application to be undeploy. The application name will be the one of the artifact folder or
   *        the packaged artifact with the extension.
   */
  void undeployApplication(String applicationName);

}
